/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser;

import hudson.FilePath;
import hudson.Functions;
import hudson.model.Computer;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.VirtualChannel;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jenkins.MasterToSlaveFileCallable;

public class NodeUtils {
    static OsType getNodeOS(Computer computer) {
        try {
            return (OsType)((Object)computer.getNode().getRootPath().act((FilePath.FileCallable)new MasterToSlaveFileCallable<OsType>(){
                private static final long serialVersionUID = -726600253548951419L;

                public OsType invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    if (!Functions.isWindows()) {
                        return OsType.OTHER;
                    }
                    Process p = Runtime.getRuntime().exec("cmd /c if defined ProgramFiles(x86) ( exit 1 ) else ( exit 0 )");
                    int exitValue = p.waitFor();
                    return exitValue == 1 ? OsType.WINDOWS_64 : OsType.WINDOWS_32;
                }
            }));
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return OsType.NOT_DEFINED;
        }
    }

    public static String uploadFileToNode(Computer computer, URL url, final String outputFileName) {
        try {
            RemoteInputStream is = new RemoteInputStream(url.openStream(), RemoteInputStream.Flag.GREEDY);
            return (String)computer.getNode().getRootPath().act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>((InputStream)is){
                private static final long serialVersionUID = 4508849758404950847L;
                final /* synthetic */ InputStream val$is;
                {
                    this.val$is = inputStream;
                }

                public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    File out = new File(f, outputFileName);
                    if (out.exists()) {
                        out.delete();
                    }
                    IOUtils.copy((InputStream)this.val$is, (File)out);
                    return out.getAbsolutePath();
                }
            });
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    static enum OsType {
        WINDOWS_32,
        WINDOWS_64,
        OTHER,
        NOT_DEFINED;

    }
}

