/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.callables;

import hudson.plugins.selenium.RemoteRunningStatus;
import hudson.plugins.selenium.callables.PropertyUtils;
import hudson.plugins.selenium.callables.RemoteStopSelenium;
import hudson.plugins.selenium.callables.SeleniumConstants;
import hudson.remoting.Callable;
import jenkins.security.MasterToSlaveCallable;

public class StopSeleniumServer
extends MasterToSlaveCallable<String, Exception> {
    private static final long serialVersionUID = 6048096509551676769L;
    private String name;

    public StopSeleniumServer(String config) {
        this.name = config;
    }

    public String call() throws Exception {
        RemoteRunningStatus rs = this.getRunningStatus();
        rs.setStatus("Stopping");
        String url = this.callOnSubProcess((Callable)new RemoteStopSelenium(), null);
        rs.setStatus("Stopped");
        rs.setRunning(false);
        rs.getSeleniumChannel().close();
        return url;
    }

    private RemoteRunningStatus getRunningStatus() {
        return (RemoteRunningStatus)PropertyUtils.getMapProperty(SeleniumConstants.PROPERTY_STATUS, this.name);
    }

    private <T, V extends Exception> T callOnSubProcess(Callable<T, V> call, T defaultValue) throws Exception {
        RemoteRunningStatus opt = (RemoteRunningStatus)PropertyUtils.getMapProperty(SeleniumConstants.PROPERTY_STATUS, this.name);
        if (opt == null) {
            return defaultValue;
        }
        return (T)opt.getSeleniumChannel().call(call);
    }
}

