/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.callables;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.selenium.RemoteControlLauncher;
import hudson.plugins.selenium.RemoteRunningStatus;
import hudson.plugins.selenium.callables.PropertyUtils;
import hudson.plugins.selenium.callables.SeleniumConstants;
import hudson.plugins.selenium.process.ProcessArgument;
import hudson.plugins.selenium.process.SeleniumProcessUtils;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.ArrayUtils;

public class SeleniumCallable
extends MasterToSlaveFileCallable<String> {
    private static final long serialVersionUID = 2047557797415325512L;
    private static final String ROLE_PARAM = "-role";
    private static final String ROLE_NODE_VALUE = "node";
    private static final String HUB_PARAM = "-hub";
    private static final Logger LOGGER = Logger.getLogger(SeleniumCallable.class.getName());
    private FilePath seleniumJar;
    private FilePath htmlUnitDriverJar;
    private long seleniumJarTimestamp;
    private long htmlUnitDriverJarTimestamp;
    private String nodeName;
    private SeleniumRunOptions options;
    private String config;
    private TaskListener listener;
    private String[] defaultArgs;

    public SeleniumCallable(FilePath seleniumJar, FilePath htmlUnitDriverJar, String nodehost, String masterName, int masterPort, String nodeName, TaskListener listener, String confName, SeleniumRunOptions options) throws InterruptedException, IOException {
        this.seleniumJar = seleniumJar;
        this.seleniumJarTimestamp = seleniumJar.lastModified();
        this.htmlUnitDriverJar = htmlUnitDriverJar;
        this.htmlUnitDriverJarTimestamp = htmlUnitDriverJar.lastModified();
        this.nodeName = nodeName;
        this.options = options;
        this.listener = listener;
        this.config = confName;
        this.defaultArgs = new String[]{ROLE_PARAM, ROLE_NODE_VALUE, HUB_PARAM, "http://" + masterName + ":" + masterPort + "/wd/hub"};
    }

    public String invoke(File f, VirtualChannel channel) throws IOException {
        RemoteRunningStatus status = (RemoteRunningStatus)PropertyUtils.getMapProperty(SeleniumConstants.PROPERTY_STATUS, this.config);
        if (status != null && status.isRunning()) {
            return null;
        }
        File localSeleniumJar = new File(f, this.seleniumJar.getName());
        File localHtmlUnitDriverJar = new File(f, this.htmlUnitDriverJar.getName());
        if (localSeleniumJar.lastModified() != this.seleniumJarTimestamp) {
            try {
                this.seleniumJar.copyTo(new FilePath(localSeleniumJar));
                localSeleniumJar.setLastModified(this.seleniumJarTimestamp);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to copy grid jar", e);
            }
        }
        if (localHtmlUnitDriverJar.lastModified() != this.htmlUnitDriverJarTimestamp) {
            try {
                this.htmlUnitDriverJar.copyTo(new FilePath(localHtmlUnitDriverJar));
                localHtmlUnitDriverJar.setLastModified(this.htmlUnitDriverJarTimestamp);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to copy htmlunit driver jar", e);
            }
        }
        try {
            this.listener.getLogger().println("Creating selenium node VM");
            Channel jvm = SeleniumProcessUtils.createSeleniumRCVM(localSeleniumJar, localHtmlUnitDriverJar, this.listener, this.options.getJVMArguments(), this.options.getEnvironmentVariables());
            status = new RemoteRunningStatus(jvm, this.options);
            status.setStatus("Starting");
            ArrayList<String> arguments = new ArrayList<String>(this.options.getSeleniumArguments().size());
            for (ProcessArgument arg : this.options.getSeleniumArguments()) {
                arguments.addAll(arg.toArgumentsList());
            }
            Object[] allArgs = ArrayUtils.addAll((Object[])this.defaultArgs, (Object[])arguments.toArray(new String[arguments.size()]));
            this.listener.getLogger().println("Starting the selenium node process. Args: " + Arrays.toString(allArgs));
            jvm.callAsync((Callable)new RemoteControlLauncher(this.nodeName, (String[])allArgs));
            status.setStatus("Started");
            status.setRunning(true);
        }
        catch (Exception t) {
            if (status == null) {
                status = new RemoteRunningStatus(null, this.options);
            }
            status.setRunning(false);
            status.setStatus("Error");
            LOGGER.log(Level.WARNING, "Selenium node launch failed", t);
            this.listener.getLogger().println("Selenium node launch failed" + t.getMessage());
            throw new IOException("Selenium node launch interrupted", t);
        }
        PropertyUtils.setMapProperty(SeleniumConstants.PROPERTY_STATUS, this.config, status);
        return this.config;
    }
}

