/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.plugins.selenium.SeleniumTestSlot;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SeleniumTestSlotGroup
implements Comparable<SeleniumTestSlotGroup>,
Serializable {
    private static final long serialVersionUID = 8967484262051147802L;
    private URL host;
    private List<SeleniumTestSlot> slots = new ArrayList<SeleniumTestSlot>();

    public SeleniumTestSlotGroup(URL host) {
        this.host = host;
    }

    public List<SeleniumTestSlot> getSlots() {
        return this.slots;
    }

    public void addTestSlot(SeleniumTestSlot slot) {
        this.slots.add(slot);
    }

    public String getHostAndPort() {
        return this.host.toExternalForm();
    }

    @Exported
    public String getHost() {
        return this.host.getHost();
    }

    @Exported
    public int getPort() {
        return this.host.getPort();
    }

    public String getSummary() {
        TreeMap<String, BusyCounter> counters = new TreeMap<String, BusyCounter>();
        for (SeleniumTestSlot slot : this.slots) {
            String browser = slot.getBrowserName();
            BusyCounter c = (BusyCounter)counters.get(browser);
            if (c == null) {
                c = new BusyCounter();
                counters.put(browser, c);
            }
            ++c.count;
            if (slot.isReserved()) continue;
            ++c.free;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : counters.entrySet()) {
            BusyCounter counter = (BusyCounter)entry.getValue();
            sb.append((String)entry.getKey()).append(" ").append(counter.free).append("/").append(counter.count).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Override
    public int compareTo(SeleniumTestSlotGroup that) {
        int r = this.getHost().compareTo(that.getHost());
        if (r != 0) {
            return r;
        }
        return this.getPort() - that.getPort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeleniumTestSlotGroup that = (SeleniumTestSlotGroup)o;
        return new EqualsBuilder().append((Object)this.host, (Object)that.host).append(this.slots, that.slots).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.host).append(this.slots).toHashCode();
    }

    private static class BusyCounter {
        int free = 0;
        int count = 0;

        private BusyCounter() {
        }
    }
}

