/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;

@ExportedBean
public class SeleniumTestSlot
implements Comparable<SeleniumTestSlot>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> ENV_MAPPING = new HashMap<String, String>();
    private final boolean isReserved;
    private final URL host;
    private final Map<String, String> capabilities;

    public SeleniumTestSlot(TestSlot testSlot) {
        RemoteProxy proxy = testSlot.getProxy();
        this.host = proxy.getRemoteHost();
        this.capabilities = this.toCapabilities(testSlot);
        this.isReserved = testSlot.getSession() != null;
    }

    private Map<String, String> toCapabilities(TestSlot testSlot) {
        HashMap<String, String> r = new HashMap<String, String>();
        for (Map.Entry e : testSlot.getCapabilities().entrySet()) {
            r.put((String)e.getKey(), e.getValue().toString());
        }
        return r;
    }

    @Exported
    public String getHost() {
        return this.host.getHost();
    }

    @Exported
    public int getPort() {
        return this.host.getPort();
    }

    @Exported
    public Map<String, String> getCapabilities() {
        return this.capabilities;
    }

    @Exported
    public boolean isReserved() {
        return this.isReserved;
    }

    public String getStatus() {
        if (this.isReserved) {
            return "In use";
        }
        return "Idle";
    }

    public String getBrowserName() {
        return this.getCapabilities().get("browserName");
    }

    public String getUnifiedBrowserName() {
        String browser = this.getCapabilities().get("browserName");
        String unified = ENV_MAPPING.get(browser);
        return unified != null ? unified : browser;
    }

    @Override
    public int compareTo(SeleniumTestSlot that) {
        int r = this.getHost().compareTo(that.getHost());
        if (r != 0) {
            return r;
        }
        return this.getPort() - that.getPort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeleniumTestSlot that = (SeleniumTestSlot)o;
        return new EqualsBuilder().append(this.isReserved, that.isReserved).append((Object)this.host, (Object)that.host).append(this.capabilities, that.capabilities).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.isReserved).append((Object)this.host).append(this.capabilities).toHashCode();
    }

    static {
        ENV_MAPPING.put("*iexplore", "internet explorer");
        ENV_MAPPING.put("*firefox", "firefox");
        ENV_MAPPING.put("*googlechrome", "chrome");
        ENV_MAPPING.put("*opera", "opera");
        ENV_MAPPING.put("*MicrosoftEdge", "Microsoft Edge");
    }
}

