/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.plugins.selenium.ConfigurationBuilder;
import hudson.plugins.selenium.JenkinsCapabilityMatcher;
import hudson.plugins.selenium.callables.PropertyUtils;
import hudson.plugins.selenium.callables.SeleniumConstants;
import hudson.remoting.Channel;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.server.SeleniumServer;

public class RemoteControlLauncher
extends MasterToSlaveCallable<Void, Exception> {
    private static final Logger LOGGER = Logger.getLogger(RemoteControlLauncher.class.getName());
    private static final long serialVersionUID = -6502768962889139192L;
    private final String[] args;
    private final String nodeName;

    public RemoteControlLauncher(String nodeName, String[] args) {
        this.nodeName = nodeName;
        this.args = args;
    }

    public Void call() throws Exception {
        try {
            RegistrationRequest c = new RegistrationRequest(ConfigurationBuilder.buildNodeConfig(this.args), this.nodeName);
            for (MutableCapabilities dc : c.getConfiguration().capabilities) {
                JenkinsCapabilityMatcher.enhanceCapabilities(dc, this.nodeName);
            }
            SelfRegisteringRemote remote = new SelfRegisteringRemote(c);
            remote.setRemoteServer((GridNodeServer)new SeleniumServer((StandaloneConfiguration)c.getConfiguration()));
            PropertyUtils.setProperty(SeleniumConstants.PROPERTY_INSTANCE, remote);
            remote.startRemoteServer();
            remote.startRegistrationProcess();
            Channel.current().waitForProperty(SeleniumConstants.PROPERTY_LOCK);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }
}

