/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import antlr.ANTLRException;
import hudson.model.Label;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.MutableCapabilities;

public class JenkinsCapabilityMatcher
implements CapabilityMatcher {
    private static final Logger LOGGER = Logger.getLogger(JenkinsCapabilityMatcher.class.getName());
    public static final String LABEL = "jenkins:label";
    public static final String NODE_NAME = "jenkins:nodeName";
    public static final String MASTER_NAME = "(master)";
    private final CapabilityMatcher base;
    private final Channel master;

    public JenkinsCapabilityMatcher(Channel master, CapabilityMatcher base) {
        this.master = master;
        this.base = base;
    }

    public boolean matches(Map<String, Object> currentCapability, Map<String, Object> requestedCapability) {
        boolean nodeMatch;
        LOGGER.log(Level.INFO, "CURRENT : " + currentCapability.toString());
        LOGGER.log(Level.INFO, "REQUEST : " + requestedCapability.toString());
        if (!this.base.matches(currentCapability, requestedCapability)) {
            return false;
        }
        Object label = requestedCapability.get(LABEL);
        Object reqNode = requestedCapability.get(NODE_NAME);
        String nodeName = (String)currentCapability.get(NODE_NAME);
        if (label == null && reqNode == null) {
            return true;
        }
        LOGGER.log(Level.INFO, "NODE : " + reqNode + " - " + nodeName);
        if (reqNode != null && nodeName != null) {
            LOGGER.log(Level.INFO, "BOTH NOT NULL");
            nodeMatch = nodeName.equals(reqNode);
        } else {
            boolean bl = nodeMatch = reqNode == null;
        }
        if (label == null) {
            return nodeMatch;
        }
        String labelExpr = label.toString();
        if (labelExpr.trim().length() == 0) {
            LOGGER.log(Level.INFO, "returning node match");
            return nodeMatch;
        }
        try {
            return nodeMatch && (Boolean)this.master.call((Callable)new LabelMatcherCallable(nodeName, labelExpr)) != false;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to communicate with master for capability matching", e);
        }
        catch (ANTLRException e) {
            LOGGER.log(Level.INFO, "Invalid label expression: " + label, e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.INFO, "Failed to communicate with master for capability matching", e);
        }
        return false;
    }

    public static void enhanceCapabilities(MutableCapabilities capabilities, String node) {
        String nodeName = StringUtils.isEmpty((String)node) ? MASTER_NAME : node;
        capabilities.setCapability(NODE_NAME, nodeName);
    }

    private static class LabelMatcherCallable
    extends MasterToSlaveCallable<Boolean, ANTLRException> {
        private static final long serialVersionUID = 1L;
        private final String nodeName;
        private final String labelExpr;

        public LabelMatcherCallable(String nodeName, String labelExpr) {
            this.nodeName = nodeName.equals(JenkinsCapabilityMatcher.MASTER_NAME) ? "" : nodeName;
            this.labelExpr = labelExpr;
        }

        public Boolean call() throws ANTLRException {
            Node n = Jenkins.getInstance().getNode(this.nodeName);
            if (n == null) {
                return false;
            }
            return Label.parseExpression((String)this.labelExpr).matches(n);
        }
    }
}

