/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.plugins.selenium.ConfigurationBuilder;
import hudson.plugins.selenium.HubHolder;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import org.jfree.util.Log;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.web.Hub;

public class HubLauncher
extends MasterToSlaveCallable<Void, Exception> {
    private static final long serialVersionUID = 5658971914841423874L;
    private final int port;
    private final String[] args;
    private final Level logLevel;

    public HubLauncher(int port, String[] args, Level logLevel) {
        this.port = port;
        this.args = args;
        this.logLevel = logLevel;
    }

    public Void call() {
        try {
            Logger log = Logger.getLogger(HubLauncher.class.getName());
            log.log(Level.OFF, "Grid hub starting with log level " + this.logLevel.getName());
            log.log(Level.OFF, "Grid Hub preparing to start on port " + this.port);
            GridHubConfiguration c = ConfigurationBuilder.buildHubConfig(this.args, this.port);
            Hub hub = new Hub(c);
            hub.start();
            HubHolder.setHub(hub);
            StringBuilder arguments = new StringBuilder();
            for (String arg : this.args) {
                arguments.append(" ").append(arg);
            }
            log.log(Level.OFF, "Grid Hub started on port " + this.port + " with args:" + arguments.toString());
            this.configureLoggers();
        }
        catch (Exception e) {
            Log.error((Object)"An error occurred while starting the hub", (Exception)e);
        }
        return null;
    }

    private void configureLoggers() {
        Logger.getLogger("org.openqa").setLevel(this.logLevel);
        Logger.getLogger("org.seleniumhq").setLevel(this.logLevel);
        Logger.getLogger("com.thoughtworks.selenium").setLevel(this.logLevel);
        Logger.getLogger("org.apache.commons.httpclient").setLevel(this.logLevel);
        Logger.getLogger("hudson.plugins.selenium").setLevel(this.logLevel);
    }
}

