/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.util;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public class UserFilter {
    @CheckForNull
    private final String includeRegex4User;
    @CheckForNull
    private final transient Pattern includePattern4User;

    public UserFilter() {
        this.includeRegex4User = null;
        this.includePattern4User = null;
    }

    @Restricted(value={NoExternalUse.class})
    public UserFilter(StaplerRequest req) throws Descriptor.FormException {
        if (req.getParameter("useincluderegex4user") != null) {
            this.includeRegex4User = Util.nullify((String)req.getParameter("_.includeRegex4User"));
            if (this.includeRegex4User == null) {
                this.includePattern4User = null;
            } else {
                try {
                    this.includePattern4User = Pattern.compile(this.includeRegex4User);
                }
                catch (PatternSyntaxException exception) {
                    throw new Descriptor.FormException(exception.getDescription(), "includeRegex4User");
                }
            }
        } else {
            this.includeRegex4User = null;
            this.includePattern4User = null;
        }
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<User> doFilter() {
        TreeSet<String> names = new TreeSet<String>();
        for (User user : User.getAll()) {
            String userId = user.getId();
            if (this.includePattern4User == null) {
                names.add(userId);
                continue;
            }
            if (!this.includePattern4User.matcher(userId).matches()) continue;
            names.add(userId);
        }
        ArrayList<User> items = new ArrayList<User>(names.size());
        for (String n : names) {
            User item = User.get((String)n, (boolean)false, null);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    @CheckForNull
    public Pattern getIncludePattern() {
        return this.includePattern4User;
    }

    @CheckForNull
    public String getIncludeRegex() {
        return this.includeRegex4User;
    }
}

