/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.util;

import hudson.DescriptorExtensionList;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AllView;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public class JobFilter {
    @Nonnull
    private List<ViewJobFilter> jobFilters;
    @CheckForNull
    private final String includeRegex;
    @CheckForNull
    private final String report4folder;
    @CheckForNull
    private transient Pattern includePattern;
    @CheckForNull
    private final Boolean statusFilter;

    public JobFilter() {
        this.statusFilter = null;
        this.jobFilters = new LinkedList<ViewJobFilter>();
        this.includeRegex = null;
        this.report4folder = null;
    }

    @Restricted(value={NoExternalUse.class})
    public JobFilter(@Nonnull StaplerRequest req) throws Descriptor.FormException, ServletException {
        String filter;
        if (req.getParameter("useincluderegex") != null) {
            this.includeRegex = Util.nullify((String)req.getParameter("_.includeRegex"));
            this.includePattern = this.includeRegex == null ? null : Pattern.compile(this.includeRegex);
        } else {
            this.includeRegex = null;
            this.includePattern = null;
        }
        this.report4folder = req.getParameter("usefolder") != null ? req.getParameter("selectedFolder") : null;
        ArrayList<ViewJobFilter> items = new ArrayList<ViewJobFilter>();
        Object formData = req.getSubmittedForm().get("jobFilters");
        DescriptorExtensionList descriptors = ViewJobFilter.all();
        if (formData != null) {
            for (Object o : JSONArray.fromObject((Object)formData)) {
                JSONObject jo = (JSONObject)o;
                String kind = jo.getString("$class");
                Descriptor d = Descriptor.findByDescribableClassName((Collection)descriptors, (String)kind);
                if (d == null) continue;
                items.add((ViewJobFilter)d.newInstance(req, jo));
            }
        }
        this.statusFilter = (filter = Util.fixEmpty((String)req.getParameter("statusFilter"))) != null ? Boolean.valueOf("1".equals(filter)) : null;
        this.jobFilters = items;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<TopLevelItem> doFilter(@Nonnull AllView view) {
        void var7_12;
        String itemName;
        ArrayList<TopLevelItem> allItems;
        TreeSet<String> names = new TreeSet<String>();
        Jenkins jenkins = JenkinsHelper.getInstanceOrFail();
        if (this.report4folder != null) {
            TopLevelItem folder = JenkinsHelper.getInstanceOrFail().getItem(this.report4folder);
            if (!(folder instanceof ItemGroup)) throw new IllegalStateException(this.report4folder + " is not an ItemGroup");
            Collection collection = ((ItemGroup)folder).getItems();
            allItems = new ArrayList<TopLevelItem>(collection.size());
            for (Item item : collection) {
                if (!(item instanceof TopLevelItem)) continue;
                allItems.add((TopLevelItem)item);
            }
        } else {
            allItems = JenkinsHelper.getInstanceOrFail().getAllItems(TopLevelItem.class);
        }
        if (this.includePattern != null) {
            for (Item item : allItems) {
                itemName = item.getFullName();
                if (!this.includePattern.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
        } else {
            for (Item item : allItems) {
                itemName = item.getFullName();
                names.add(itemName);
            }
        }
        Boolean localStatusFilter = this.statusFilter;
        ArrayList<TopLevelItem> arrayList = new ArrayList<TopLevelItem>();
        for (String string : names) {
            TopLevelItem item = (TopLevelItem)jenkins.getItemByFullName(string, TopLevelItem.class);
            if (item == null || localStatusFilter != null && item instanceof AbstractProject && !(((AbstractProject)item).isDisabled() ^ localStatusFilter)) continue;
            arrayList.add(item);
        }
        List<ViewJobFilter> localJobFilters = this.getJobFilters();
        for (ViewJobFilter jobFilter : localJobFilters) {
            List list = jobFilter.filter((List)var7_12, allItems, (View)view);
        }
        return var7_12;
    }

    @Nonnull
    public List<ViewJobFilter> getJobFilters() {
        return this.jobFilters;
    }

    @CheckForNull
    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    @CheckForNull
    public String getIncludeRegex() {
        return this.includeRegex;
    }

    @CheckForNull
    public Boolean getStatusFilter() {
        return this.statusFilter;
    }
}

