/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.util;

import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public class ComputerFilter {
    @CheckForNull
    private final String includeRegex4Slave;
    @CheckForNull
    private final transient Pattern includePattern4Slave;

    public ComputerFilter() {
        this.includeRegex4Slave = null;
        this.includePattern4Slave = null;
    }

    @Restricted(value={NoExternalUse.class})
    public ComputerFilter(@Nonnull StaplerRequest req) throws Descriptor.FormException {
        if (req.getParameter("useincluderegex4slave") != null) {
            this.includeRegex4Slave = Util.nullify((String)req.getParameter("_.includeRegex4Slave"));
            if (this.includeRegex4Slave == null) {
                this.includePattern4Slave = null;
            } else {
                try {
                    this.includePattern4Slave = Pattern.compile(this.includeRegex4Slave);
                }
                catch (PatternSyntaxException ex) {
                    throw new Descriptor.FormException("Invalid regular expression", (Throwable)ex, "includeRegex4Slave");
                }
            }
        } else {
            this.includeRegex4Slave = null;
            this.includePattern4Slave = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<Computer> doFilter() {
        Jenkins jenkins = JenkinsHelper.getInstanceOrFail();
        Computer[] computerArray = this;
        synchronized (this) {
            TreeSet<String> names = new TreeSet<String>();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Computer item : jenkins.getComputers()) {
                String itemName = item.getName();
                if (this.includePattern4Slave == null) {
                    names.add(itemName);
                    continue;
                }
                if (!this.includePattern4Slave.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
            ArrayList<Computer> items = new ArrayList<Computer>(names.size());
            for (String n : names) {
                Computer item;
                item = jenkins.getComputer(n);
                if (item == null) continue;
                items.add(item);
            }
            return items;
        }
    }

    @CheckForNull
    public Pattern getIncludePattern() {
        return this.includePattern4Slave;
    }

    @CheckForNull
    public String getIncludeRegex() {
        return this.includeRegex4Slave;
    }
}

