/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.collections.map.MultiKeyMap;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class SecurityInspectorReport<TRow, TColumnGroup, TColumnItem, TEntryReport> {
    @Nonnull
    private final MultiKeyMap entries = new MultiKeyMap();
    @Nonnull
    private final Set<TColumnGroup> groups = new HashSet<TColumnGroup>();
    @Nonnull
    private final Set<TRow> rows = new TreeSet<TRow>(this.getRowComparator());
    @Nonnull
    private final Set<TColumnItem> columns = new HashSet<TColumnItem>();

    @Nonnull
    public abstract String getReportTargetName();

    SecurityInspectorReport() {
    }

    @Nonnull
    public MultiKeyMap getEntries() {
        return this.entries;
    }

    @Nonnull
    public Set<TColumnGroup> getGroups() {
        return this.groups;
    }

    @Nonnull
    public Set<TRow> getRows() {
        return this.rows;
    }

    @Nonnull
    public Set<TColumnItem> getColumns() {
        return this.columns;
    }

    @CheckForNull
    public final TEntryReport getEntry(@Nonnull TRow row, @Nonnull TColumnItem column) {
        Object object = this.entries.get(row, column);
        return (TEntryReport)object;
    }

    public void forRow(@Nonnull TRow row, @Nonnull Runnable runnable) {
        runnable.run();
    }

    public final void generateReport(@Nonnull Set<TRow> rows, final @Nonnull Set<TColumnItem> columns, @Nonnull Set<TColumnGroup> groups) {
        this.groups.addAll(groups);
        this.rows.addAll(rows);
        this.columns.addAll(columns);
        for (final TRow row : rows) {
            this.forRow(row, new Runnable(){

                @Override
                public void run() {
                    for (Object column : columns) {
                        SecurityInspectorReport.this.entries.put(row, column, SecurityInspectorReport.this.getEntryReport(row, column));
                    }
                }
            });
        }
    }

    protected final void fillRowByResult(@Nonnull TRow row, TEntryReport result) {
        for (TColumnItem column : this.columns) {
            this.entries.put(row, column, result);
        }
    }

    @Nonnull
    public Comparator<TRow> getRowComparator() {
        return new Comparator<TRow>(){

            @Override
            public int compare(TRow o1, TRow o2) {
                return SecurityInspectorReport.this.getRowTitle(o1).compareTo(SecurityInspectorReport.this.getRowTitle(o2));
            }
        };
    }

    @Nonnull
    public Comparator<TColumnItem> getColumnComparator() {
        return new Comparator<TColumnItem>(){

            @Override
            public int compare(TColumnItem o1, TColumnItem o2) {
                String o2def;
                String o1def = SecurityInspectorReport.this.getGroupTitle(SecurityInspectorReport.this.getGroupOfItem(o1));
                int cmp = o1def.compareTo(o2def = SecurityInspectorReport.this.getGroupTitle(SecurityInspectorReport.this.getGroupOfItem(o2)));
                return cmp != 0 ? cmp : SecurityInspectorReport.this.getColumnTitle(o1).compareTo(SecurityInspectorReport.this.getColumnTitle(o2));
            }
        };
    }

    @Nonnull
    public abstract TColumnGroup getGroupOfItem(@Nonnull TColumnItem var1);

    @Nonnull
    public abstract Collection<TColumnItem> getItemsOfGroup(@Nonnull TColumnGroup var1);

    @Nonnull
    protected abstract TEntryReport getEntryReport(@Nonnull TRow var1, @Nonnull TColumnItem var2);

    @Nonnull
    public abstract String getRowColumnHeader();

    @Nonnull
    public abstract String getRowTitle(@Nonnull TRow var1);

    @Nonnull
    public abstract String getGroupTitle(@Nonnull TColumnGroup var1);

    @Nonnull
    public abstract String getColumnTitle(@Nonnull TColumnItem var1);

    public abstract boolean isEntryReportOk(@Nonnull TRow var1, @Nonnull TColumnItem var2, @Nonnull TEntryReport var3);

    protected final String[][] getReportInMatrix() {
        Set<TRow> allRows = this.getRows();
        TreeSet<TColumnItem> sortedColumns = new TreeSet<TColumnItem>(this.getColumnComparator());
        sortedColumns.addAll(this.columns);
        String[][] report = new String[this.getColumns().size() + 1][allRows.size() + 2];
        report[0][0] = "Groups";
        report[0][1] = "Permissions";
        int NColumn = 1;
        for (Object column : sortedColumns) {
            report[NColumn][0] = this.getGroupTitle(this.getGroupOfItem(column));
            report[NColumn][1] = this.getColumnTitle(column);
            ++NColumn;
        }
        int NRow = 2;
        for (TRow row : allRows) {
            report[0][NRow] = this.getRowTitle(row);
            NColumn = 1;
            for (Object column : sortedColumns) {
                Object entry = this.getEntries().get(row, column);
                report[NColumn][NRow] = entry != null ? entry.toString() : "null";
                ++NColumn;
            }
            ++NRow;
        }
        return report;
    }

    @Restricted(value={NoExternalUse.class})
    public String getReportInCSV() {
        Jenkins jenkins = JenkinsHelper.getInstanceOrFail();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        String[][] report = this.getReportInMatrix();
        StringBuilder reportCSV = new StringBuilder();
        reportCSV.append("sep=,").append("\n");
        for (int NRow = 0; NRow < this.getRows().size() + 2; ++NRow) {
            for (int NColumn = 0; NColumn < this.getColumns().size() + 1; ++NColumn) {
                reportCSV.append(report[NColumn][NRow]).append(",");
            }
            reportCSV.append("\n");
        }
        return reportCSV.toString();
    }
}

