/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.model;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.securityinspector.model.SecurityInspectorReport;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ReportBuilder
implements ExtensionPoint {
    @Nonnull
    public abstract Type getType();

    @Nonnull
    public abstract String getIcon();

    @Nonnull
    public abstract String getIndex();

    @Nonnull
    public abstract String getDisplayName();

    @Nonnull
    public abstract String getDescription();

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public abstract SecurityInspectorReport getReport();

    @Nonnull
    public static ExtensionList<ReportBuilder> all() {
        return ExtensionList.lookup(ReportBuilder.class);
    }

    @Nonnull
    public static List<ReportBuilder> all(@Nonnull Type type) {
        ExtensionList<ReportBuilder> all = ReportBuilder.all();
        ArrayList<ReportBuilder> res = new ArrayList<ReportBuilder>();
        for (ReportBuilder rb : all) {
            if (rb.getType() != type) continue;
            res.add(rb);
        }
        return res;
    }

    public abstract void processParameters(@Nonnull StaplerRequest var1) throws Descriptor.FormException, ServletException;

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doFilterSubmit(@Nonnull StaplerRequest req) throws ServletException, Descriptor.FormException {
        Jenkins jenkins = JenkinsHelper.getInstanceOrFail();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        SubmittedOperation action = SubmittedOperation.fromRequest(req);
        switch (action) {
            case Submit: {
                this.processParameters(req);
                break;
            }
            case Back: {
                return HttpResponses.redirectTo((String)(jenkins.getRootUrl() + "security-inspector"));
            }
            default: {
                throw new Descriptor.FormException("Action " + (Object)((Object)action) + " is not supported", "submit");
            }
        }
        return HttpResponses.redirectTo((String)"report");
    }

    @Restricted(value={NoExternalUse.class})
    public void doProcessReportAction(@Nonnull StaplerRequest req, @Nonnull StaplerResponse rsp) throws ServletException, Descriptor.FormException, IOException {
        Jenkins jenkins = JenkinsHelper.getInstanceOrFail();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        SubmittedOperation action = SubmittedOperation.fromRequest(req);
        switch (action) {
            case GoHome: {
                rsp.sendRedirect("..");
                break;
            }
            case Download: {
                this.doDownloadReport(rsp);
                break;
            }
            default: {
                throw new Descriptor.FormException("Action " + (Object)((Object)action) + " is not supported", "submit");
            }
        }
    }

    private void doDownloadReport(@Nonnull StaplerResponse rsp) {
        SecurityInspectorReport report4Download = this.getReport();
        rsp.setCharacterEncoding("UTF_8");
        rsp.setContentType("text/csv;charset=UTF-8");
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        rsp.setHeader("Content-Disposition", "attachment; filename=\"report-for-" + report4Download.getReportTargetName() + "-" + f.format(new Date()) + ".csv\"");
        try (ServletOutputStream outputStream = rsp.getOutputStream();){
            String report = report4Download.getReportInCSV();
            outputStream.write(report.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
            outputStream.flush();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static enum Type {
        ITEM,
        USER,
        COMPUTER;

    }

    private static enum SubmittedOperation {
        Submit,
        Back,
        GoHome,
        Download;


        @Nonnull
        static SubmittedOperation fromRequest(@Nonnull StaplerRequest req) throws Descriptor.FormException {
            Map map = req.getParameterMap();
            for (SubmittedOperation val : SubmittedOperation.values()) {
                if (!map.containsKey(val.toString())) continue;
                return val;
            }
            throw new Descriptor.FormException("Cannot find an action in the request", "submit");
        }
    }
}

