/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.model;

import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.securityinspector.model.SecurityInspectorReport;

public abstract class PermissionReport<TRow, TEntryReport>
extends SecurityInspectorReport<TRow, PermissionGroup, Permission, TEntryReport> {
    public final void generateReport(@Nonnull Set<TRow> rows, @Nonnull Set<PermissionGroup> groups) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (PermissionGroup group : groups) {
            permissions.addAll(this.getItemsOfGroup(group));
        }
        this.generateReport(rows, permissions, groups);
    }

    @Override
    public final PermissionGroup getGroupOfItem(Permission item) {
        return item.group;
    }

    @Override
    public final Collection<Permission> getItemsOfGroup(PermissionGroup group) {
        LinkedList<Permission> res = new LinkedList<Permission>();
        for (Permission p : group.getPermissions()) {
            if (!p.getEnabled()) continue;
            res.add(p);
        }
        return res;
    }

    @Override
    public final String getGroupTitle(PermissionGroup group) {
        return group.title.toString();
    }

    @Override
    public final String getColumnTitle(Permission item) {
        return item.name;
    }
}

