/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.impl.users;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.model.TopLevelItem;
import hudson.model.User;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.securityinspector.SecurityInspectorAction;
import org.jenkinsci.plugins.securityinspector.UserContext;
import org.jenkinsci.plugins.securityinspector.UserContextCache;
import org.jenkinsci.plugins.securityinspector.model.ReportBuilder;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;

public abstract class UserReportBuilder
extends ReportBuilder {
    @Override
    public final ReportBuilder.Type getType() {
        return ReportBuilder.Type.USER;
    }

    @Nonnull
    public Collection<User> getPossibleUsers() {
        TreeSet<User> sortedUser = new TreeSet<User>(this.getComparatorUser());
        sortedUser.addAll(User.getAll());
        return sortedUser;
    }

    public List<AbstractFolder> getAllFolders() {
        return JenkinsHelper.getInstanceOrFail().getAllItems(AbstractFolder.class);
    }

    @Nonnull
    public String getDisplayName(@CheckForNull TopLevelItem item) {
        return item != null ? item.getFullDisplayName() : "";
    }

    @Nonnull
    public String getDisplayName(@CheckForNull User user) {
        return user != null ? user.getFullName() + " (" + user.getId() + ")" : "";
    }

    @Nonnull
    public Comparator<User> getComparatorUser() {
        return new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public User getRequestedUser() throws HttpResponses.HttpResponseException {
        UserContext context = UserContextCache.getInstance().get(SecurityInspectorAction.getSessionId());
        if (context == null) {
            throw HttpResponses.error((int)404, (String)"Context hae not been found");
        }
        String userId = context.getItem();
        User user = User.get((String)userId, (boolean)false, null);
        if (user == null) {
            throw HttpResponses.error((int)404, (String)("User " + userId + " does not exist"));
        }
        return user;
    }
}

