/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.impl.users;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.securityinspector.Messages;
import org.jenkinsci.plugins.securityinspector.SecurityInspectorAction;
import org.jenkinsci.plugins.securityinspector.UserContext;
import org.jenkinsci.plugins.securityinspector.UserContextCache;
import org.jenkinsci.plugins.securityinspector.impl.users.UserReportBuilder;
import org.jenkinsci.plugins.securityinspector.model.PermissionReport;
import org.jenkinsci.plugins.securityinspector.model.SecurityInspectorReport;
import org.jenkinsci.plugins.securityinspector.util.ComputerFilter;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=0.0)
public class PermissionsForComputerReportBuilder
extends UserReportBuilder {
    @Override
    public String getIcon() {
        return "fingerprint.png";
    }

    @Override
    public String getIndex() {
        return "slave-filter";
    }

    @Override
    public String getDisplayName() {
        return "Single user, multiple nodes";
    }

    @Override
    public String getDescription() {
        return "Display node permissions for the specified user";
    }

    @Override
    public void processParameters(StaplerRequest req) throws Descriptor.FormException {
        String valid = req.getParameter("_.includeRegex4Slave");
        try {
            Pattern.compile(valid);
        }
        catch (PatternSyntaxException exception) {
            throw new Descriptor.FormException((Throwable)exception, "includeRegex4Slave");
        }
        String selectedItem = req.getParameter("selectedUser");
        ComputerFilter filter4slave = new ComputerFilter(req);
        List<Computer> selectedSlaves = filter4slave.doFilter();
        UserContextCache.updateSearchCache(null, selectedSlaves, null, selectedItem);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<Computer> getRequestedSlaves() throws HttpResponses.HttpResponseException {
        UserContext context = UserContextCache.getInstance().get(SecurityInspectorAction.getSessionId());
        if (context == null) {
            throw HttpResponses.error((int)404, (String)"Context has not been found");
        }
        List<Computer> selectedSlaves = context.getSlaves();
        if (selectedSlaves == null) {
            throw HttpResponses.error((int)500, (String)"The retrieved context does not contain slave filter settings");
        }
        HashSet<Computer> res = new HashSet<Computer>(selectedSlaves.size());
        for (Computer item : selectedSlaves) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityInspectorReport getReport() {
        ReportImpl report;
        Authentication auth;
        Set<Computer> computers = this.getRequestedSlaves();
        HashSet<Computer> slaves = new HashSet<Computer>();
        for (Computer c : computers) {
            Node slave = c.getNode();
            if (slave == null) continue;
            slaves.add(c);
        }
        User user = this.getRequestedUser();
        try {
            auth = user.impersonate();
        }
        catch (UsernameNotFoundException ex) {
            return new ReportImpl(user);
        }
        SecurityContext initialContext = null;
        try {
            initialContext = ACL.impersonate((Authentication)auth);
            report = ReportImpl.createReport(slaves, user);
        }
        finally {
            if (initialContext != null) {
                SecurityContextHolder.setContext((SecurityContext)initialContext);
            }
        }
        return report;
    }

    public static class ReportImpl
    extends PermissionReport<Computer, Boolean> {
        @Nonnull
        final User user4report;

        ReportImpl(@Nonnull User user) {
            this.user4report = user;
        }

        @Override
        public String getReportTargetName() {
            return this.user4report.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean getEntryReport(Computer column, Permission item) {
            Authentication auth;
            try {
                auth = this.user4report.impersonate();
            }
            catch (UsernameNotFoundException ex) {
                return Boolean.FALSE;
            }
            SecurityContext initialContext = null;
            AuthorizationStrategy strategy = JenkinsHelper.getInstanceOrFail().getAuthorizationStrategy();
            try {
                initialContext = ACL.impersonate((Authentication)auth);
                Boolean bl = strategy.getACL(column).hasPermission(item);
                return bl;
            }
            finally {
                if (initialContext != null) {
                    SecurityContextHolder.setContext((SecurityContext)initialContext);
                }
            }
        }

        public final void generateReport(@Nonnull Set<Computer> rows) {
            HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
            groups.remove(PermissionGroup.get(Permission.class));
            groups.remove(PermissionGroup.get(Hudson.class));
            groups.remove(PermissionGroup.get(View.class));
            groups.remove(PermissionGroup.get(Job.class));
            groups.remove(PermissionGroup.get(Item.class));
            groups.remove(PermissionGroup.get(SCM.class));
            groups.remove(PermissionGroup.get(Run.class));
            super.generateReport(rows, groups);
        }

        public static ReportImpl createReport(@Nonnull Set<Computer> rows, @Nonnull User user) {
            ReportImpl report = new ReportImpl(user);
            report.generateReport(rows);
            return report;
        }

        @Override
        public String getRowColumnHeader() {
            return Messages.SlaveReport_RowColumnHeader();
        }

        @Override
        public String getRowTitle(Computer row) {
            return row.getDisplayName();
        }

        @Override
        public boolean isEntryReportOk(Computer row, Permission item, Boolean report) {
            return report != null ? report : false;
        }
    }
}

