/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.impl.items;

import hudson.model.Item;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.securityinspector.SecurityInspectorAction;
import org.jenkinsci.plugins.securityinspector.UserContext;
import org.jenkinsci.plugins.securityinspector.UserContextCache;
import org.jenkinsci.plugins.securityinspector.model.ReportBuilder;
import org.jenkinsci.plugins.securityinspector.util.JenkinsHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;

public abstract class ItemReportBuilder
extends ReportBuilder {
    @Override
    public final ReportBuilder.Type getType() {
        return ReportBuilder.Type.ITEM;
    }

    @Nonnull
    public List<Item> getPossibleJobs() {
        return JenkinsHelper.getInstanceOrFail().getAllItems();
    }

    @Nonnull
    public Comparator<Item> getComparatorItem() {
        return new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.getFullName().compareTo(o2.getFullName());
            }
        };
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Item getRequestedJob() throws HttpResponses.HttpResponseException {
        UserContext context = UserContextCache.getInstance().get(SecurityInspectorAction.getSessionId());
        if (context == null) {
            throw HttpResponses.error((int)404, (String)"Context has not been found");
        }
        String jobName = context.getItem();
        Item job = JenkinsHelper.getInstanceOrFail().getItemByFullName(jobName, Item.class);
        if (job == null) {
            throw HttpResponses.error((int)404, (String)("Job " + jobName + " does not exist"));
        }
        return job;
    }
}

