/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector.impl.items;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.User;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.securityinspector.Messages;
import org.jenkinsci.plugins.securityinspector.SecurityInspectorAction;
import org.jenkinsci.plugins.securityinspector.UserContext;
import org.jenkinsci.plugins.securityinspector.UserContextCache;
import org.jenkinsci.plugins.securityinspector.impl.items.ItemReportBuilder;
import org.jenkinsci.plugins.securityinspector.model.PermissionReport;
import org.jenkinsci.plugins.securityinspector.model.SecurityInspectorReport;
import org.jenkinsci.plugins.securityinspector.util.UserFilter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class ItemForMultipleUsersReportBuilder
extends ItemReportBuilder {
    @Override
    public String getIcon() {
        return "user.png";
    }

    @Override
    public String getIndex() {
        return "users-for-item";
    }

    @Override
    public String getDisplayName() {
        return "Multiple users, single job";
    }

    @Override
    public String getDescription() {
        return "Display users permissions for the specified item";
    }

    @Override
    public void processParameters(StaplerRequest req) throws Descriptor.FormException, ServletException {
        String regex = req.getParameter("_.includeRegex4User");
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            throw new Descriptor.FormException((Throwable)exception, "includeRegex4User");
        }
        String selectedItem = req.getParameter("selectedJob");
        UserFilter filter4user = new UserFilter(req);
        List<User> selectedUsers = filter4user.doFilter();
        UserContextCache.updateSearchCache(null, null, selectedUsers, selectedItem);
    }

    @Override
    public SecurityInspectorReport getReport() {
        Set<User> users = this.getRequestedUsers();
        Item job = this.getRequestedJob();
        ReportImpl report = ReportImpl.createReport(users, job);
        return report;
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<User> getRequestedUsers() throws HttpResponses.HttpResponseException {
        UserContext context = UserContextCache.getInstance().get(SecurityInspectorAction.getSessionId());
        if (context == null) {
            throw HttpResponses.error((int)404, (String)"Context has not been found");
        }
        List<User> selectedUsers = context.getUsers();
        if (selectedUsers == null) {
            throw HttpResponses.error((int)500, (String)"The retrieved context does not contain user filter settings");
        }
        HashSet<User> res = new HashSet<User>(selectedUsers.size());
        for (User item : selectedUsers) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public static class ReportImpl
    extends PermissionReport<User, Boolean> {
        @Nonnull
        final Item job4report;

        ReportImpl(@Nonnull Item job) {
            this.job4report = job;
        }

        @Override
        public String getReportTargetName() {
            return this.job4report.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forRow(User user, Runnable runnable) {
            Authentication auth;
            try {
                auth = user.impersonate();
            }
            catch (UsernameNotFoundException ex) {
                this.fillRowByResult(user, Boolean.FALSE);
                return;
            }
            SecurityContext initialContext = null;
            try {
                initialContext = ACL.impersonate((Authentication)auth);
                runnable.run();
            }
            finally {
                if (initialContext != null) {
                    SecurityContextHolder.setContext((SecurityContext)initialContext);
                }
            }
        }

        @Override
        protected Boolean getEntryReport(User column, Permission item) {
            return this.job4report.hasPermission(item);
        }

        public final void generateReport(@Nonnull Set<User> rows) {
            HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
            groups.remove(PermissionGroup.get(Permission.class));
            groups.remove(PermissionGroup.get(Hudson.class));
            groups.remove(PermissionGroup.get(Computer.class));
            groups.remove(PermissionGroup.get(View.class));
            super.generateReport(rows, groups);
        }

        public static ReportImpl createReport(@Nonnull Set<User> rows, @Nonnull Item job) {
            ReportImpl report = new ReportImpl(job);
            report.generateReport(rows);
            return report;
        }

        @Override
        public String getRowColumnHeader() {
            return Messages.UserReport_RowColumnHeader();
        }

        @Override
        public String getRowTitle(User row) {
            return row.getId();
        }

        @Override
        public boolean isEntryReportOk(User row, Permission item, Boolean report) {
            return report != null ? report : false;
        }
    }
}

