/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector;

import hudson.model.Computer;
import hudson.model.TopLevelItem;
import hudson.model.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.securityinspector.SecurityInspectorAction;
import org.jenkinsci.plugins.securityinspector.UserContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public class UserContextCache {
    final Map<String, UserContext> contextMap = new HashMap<String, UserContext>();
    private static final UserContextCache INSTANCE = new UserContextCache();

    @Nonnull
    public static UserContextCache getInstance() {
        return INSTANCE;
    }

    private UserContextCache() {
    }

    public synchronized boolean containsKey(@Nonnull String sessionId) {
        return this.contextMap.containsKey(sessionId);
    }

    @CheckForNull
    public synchronized UserContext get(@Nonnull String sessionId) {
        return this.contextMap.get(sessionId);
    }

    public synchronized void flush(@Nonnull String sessionId) {
        if (this.contextMap.containsKey(sessionId)) {
            this.contextMap.remove(sessionId);
        }
    }

    public synchronized void put(@Nonnull String sessionId, @Nonnull UserContext context) {
        this.contextMap.put(SecurityInspectorAction.getSessionId(), context);
    }

    @Nonnull
    public static String cleanCache() {
        String sessionId = SecurityInspectorAction.getSessionId();
        INSTANCE.flush(sessionId);
        return sessionId;
    }

    public static void updateSearchCache(List<TopLevelItem> selectedJobs, List<Computer> selectedSlaves, List<User> selectedUsers, @Nonnull String item) {
        UserContextCache.cleanCache();
        INSTANCE.put(SecurityInspectorAction.getSessionId(), new UserContext(selectedJobs, selectedSlaves, selectedUsers, item));
    }
}

