/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.securityinspector;

import hudson.Extension;
import hudson.model.ManagementLink;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.securityinspector.UserContextCache;
import org.jenkinsci.plugins.securityinspector.model.ReportBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Extension
public class SecurityInspectorAction
extends ManagementLink {
    public String getIconFileName() {
        return "secure.gif";
    }

    public String getDisplayName() {
        return "Security Inspector";
    }

    public String getDescription() {
        return "Inspect permissions configured by Jenkins security settings";
    }

    public String getUrlName() {
        return "security-inspector";
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public ReportBuilder getDynamic(@Nonnull String buiderName) {
        for (ReportBuilder bldr : ReportBuilder.all()) {
            if (!bldr.getIndex().equals(buiderName)) continue;
            return bldr;
        }
        return null;
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<ReportBuilder> getReportBuilders(@Nonnull String type) {
        return ReportBuilder.all(ReportBuilder.Type.valueOf(type));
    }

    @Nonnull
    public static String getSessionId() throws IllegalStateException {
        return Stapler.getCurrentRequest().getSession().getId();
    }

    public boolean hasConfiguredFilters() {
        return UserContextCache.getInstance().containsKey(SecurityInspectorAction.getSessionId());
    }
}

