/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SectionedView
extends View {
    private DescribableList<SectionedViewSection, Descriptor<SectionedViewSection>> sections;

    public Iterable<SectionedViewSection> getSections() {
        return this.sections;
    }

    public void setSections(Collection<? extends SectionedViewSection> sections) {
        this.sections.clear();
        this.sections.addAll(sections);
    }

    @DataBoundConstructor
    public SectionedView(String name) {
        super(name);
        this.initSections();
    }

    private void initSections() {
        if (this.sections != null) {
            return;
        }
        this.sections = new DescribableList(Saveable.NOOP);
    }

    public static Collection<Job> sortJobs(Collection<Job> jobs) {
        TreeSet<Job> set = new TreeSet<Job>(new JobComparator());
        if (jobs != null) {
            set.addAll(jobs);
        }
        return set;
    }

    public static boolean isBuilding(Job job) {
        Run lastBuild = job.getLastBuild();
        return lastBuild != null && (lastBuild.isLogUpdated() || lastBuild.isBuilding());
    }

    public static Result getResult(Job job) {
        Run lastBuild;
        for (lastBuild = job.getLastBuild(); lastBuild != null && (lastBuild.hasntStartedYet() || lastBuild.isBuilding() || lastBuild.isLogUpdated()); lastBuild = lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return lastBuild.getResult();
        }
        return Result.NOT_BUILT;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException {
        this.initSections();
        try {
            this.sections.rebuildHetero(req, req.getSubmittedForm(), (Collection)Hudson.getInstance().getDescriptorList(SectionedViewSection.class), "sections");
        }
        catch (IOException e) {
            throw new Descriptor.FormException("Error rebuilding list of sections.", (Throwable)e, "sections");
        }
    }

    public boolean contains(TopLevelItem item) {
        for (SectionedViewSection section : this.sections) {
            if (!section.contains(item, (ItemGroup<? extends TopLevelItem>)this.getOwnerItemGroup())) continue;
            return true;
        }
        return false;
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Hudson.getInstance().doCreateItem(req, rsp);
    }

    public Collection<TopLevelItem> getItems() {
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>();
        for (SectionedViewSection section : this.sections) {
            items.addAll(section.getItems((ItemGroup<? extends TopLevelItem>)this.getOwnerItemGroup()));
        }
        return items;
    }

    public void onJobRenamed(Item item, String oldName, String newName) {
        for (SectionedViewSection section : this.sections) {
            if (!section.jobNames.remove(oldName) || newName == null) continue;
            section.jobNames.add(newName);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return "Sectioned View";
        }
    }

    private static final class JobComparator
    implements Comparator<Job>,
    Serializable {
        private static final long serialVersionUID = 6388545755407223000L;

        private JobComparator() {
        }

        @Override
        public int compare(Job o1, Job o2) {
            int health;
            Result r1 = SectionedView.getResult(o1);
            Result r2 = SectionedView.getResult(o2);
            if (r1 != null && r2 != null) {
                if (r1.isBetterThan(r2)) {
                    return 1;
                }
                if (r1.isWorseThan(r2)) {
                    return -1;
                }
            }
            HealthReport h1 = o1.getBuildHealth();
            HealthReport h2 = o2.getBuildHealth();
            if (h1 != null && h2 != null && (health = h1.compareTo(h2)) != 0) {
                return health;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

