/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.builder;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Failure;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormApply;
import hudson.util.QuotedStringTokenizer;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.util.xstream.CriticalXStreamException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.ScriptlerPermissions;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.ControllerGroovyScript;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ScriptlerBuilder
extends Builder
implements Serializable {
    private static final AtomicInteger CURRENT_ID = new AtomicInteger();
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ScriptlerBuilder.class.getName());
    private static final String BUILDER_ID = "builderId";
    @CheckForNull
    private final String builderId;
    @CheckForNull
    private final String scriptId;
    private final boolean propagateParams;
    @NonNull
    private final List<Parameter> parameters;

    @Deprecated(since="3.5")
    public ScriptlerBuilder(@CheckForNull String builderId, @CheckForNull String scriptId, boolean propagateParams, Parameter[] parameters) {
        this(builderId, scriptId, propagateParams, Arrays.asList(Objects.requireNonNull(parameters)));
    }

    @DataBoundConstructor
    public ScriptlerBuilder(@CheckForNull String builderId, @CheckForNull String scriptId, boolean propagateParams, @NonNull List<Parameter> parameters) {
        this.builderId = builderId;
        this.scriptId = scriptId;
        this.parameters = new ArrayList<Parameter>(parameters);
        this.propagateParams = propagateParams;
    }

    @NonNull
    private Map<String, String> checkGenericData() {
        HashMap<String, String> errors = new HashMap<String, String>();
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script != null && !script.nonAdministerUsing) {
            errors.put("scriptId", "The script is not allowed to be executed in a build, check its configuration!");
        }
        this.checkPermission(errors);
        return errors;
    }

    private void checkPermission(@NonNull Map<String, String> errors) {
        if (Jenkins.get().hasPermission(ScriptlerPermissions.CONFIGURE)) {
            return;
        }
        Project<?, ?> project = this.retrieveProjectUsingCurrentRequest();
        if (!this.getAllScriptlerBuildersFromProject(project).contains(this)) {
            String message = this.builderId == null || this.builderId.isBlank() ? "As the given builder does not have ID, it must be equals to one of the existing builder that does not have ID" : "The builderId must correspond to an existing builder of that project since the user does not have the rights to add/edit Scriptler step";
            errors.put(BUILDER_ID, message);
        }
    }

    private ScriptlerBuilder recreateBuilderWithBuilderIdIfRequired() {
        if (this.builderId == null || this.builderId.isBlank()) {
            return new ScriptlerBuilder(ScriptlerBuilder.generateBuilderId(), this.scriptId, this.propagateParams, this.parameters);
        }
        return this;
    }

    @NonNull
    private List<ScriptlerBuilder> getAllScriptlerBuildersFromProject(@CheckForNull Project<?, ?> project) {
        if (project == null) {
            return List.of();
        }
        return project.getBuildersList().getAll(ScriptlerBuilder.class);
    }

    @CheckForNull
    private Project<?, ?> retrieveProjectUsingCurrentRequest() {
        return Optional.ofNullable(Stapler.getCurrentRequest2()).map(req -> (Project)req.findAncestorObject(Project.class)).orElse(null);
    }

    @CheckForNull
    public String getScriptId() {
        return this.scriptId;
    }

    @Deprecated(since="3.5")
    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[0]);
    }

    @NonNull
    public List<Parameter> getParametersList() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getBuilderId() {
        return this.builderId;
    }

    public boolean isPropagateParams() {
        return this.propagateParams;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script == null) {
            if (this.scriptId == null || this.scriptId.isBlank()) {
                LOGGER.log(Level.WARNING, "The script id was blank for the build {0}:{1}", new Object[]{build.getProject().getName(), build.getDisplayName()});
                listener.getLogger().println(Messages.scriptNotDefined());
            } else {
                LOGGER.log(Level.WARNING, "The source corresponding to the scriptId {0} was not found (missing file ?) for the build {1}:{2}", new Object[]{this.scriptId, build.getProject().getName(), build.getDisplayName()});
                listener.getLogger().println(Messages.scriptNotFound(this.scriptId));
            }
            return false;
        }
        boolean isOk = false;
        if (!script.nonAdministerUsing) {
            listener.getLogger().println(Messages.scriptNotUsableInBuildStep(script.getName()));
            LOGGER.log(Level.WARNING, "The script [{0} ({1})] is not allowed to be executed in a build, check its configuration. It concerns the build [{2}:{3}]", new Object[]{script.getName(), script.getId(), build.getProject().getName(), build.getDisplayName()});
            return false;
        }
        if (!ScriptHelper.isApproved(script.getScriptText())) {
            listener.getLogger().println(Messages.scriptNotApprovedYet(script.getName()));
            LOGGER.log(Level.WARNING, "The script [{0} ({1})] is not approved yet, consider asking your administrator to approve it. It concerns the build [{2}:{3}]", new Object[]{script.getName(), script.getId(), build.getProject().getName(), build.getDisplayName()});
            return false;
        }
        try {
            Object output;
            LinkedList<Parameter> expandedParams = new LinkedList<Parameter>();
            if (this.propagateParams) {
                ParametersAction paramsAction = (ParametersAction)build.getAction(ParametersAction.class);
                if (paramsAction == null) {
                    listener.getLogger().println(Messages.no_parameters_defined());
                } else {
                    List jobParams = paramsAction.getParameters();
                    for (ParameterValue parameterValue : jobParams) {
                        String macro = "${" + parameterValue.getName() + "}";
                        String value = TokenMacro.expandAll(build, (TaskListener)listener, (String)macro, (boolean)false, null);
                        expandedParams.add(new Parameter(parameterValue.getName(), value));
                    }
                }
            }
            for (Parameter parameter : this.parameters) {
                expandedParams.add(new Parameter(parameter.getName(), TokenMacro.expandAll(build, (TaskListener)listener, (String)parameter.getValue())));
            }
            if (script.onlyController) {
                output = FilePath.localChannel.call((Callable)new ControllerGroovyScript(script.getScriptText(), expandedParams, true, (TaskListener)listener, launcher, build));
            } else {
                VirtualChannel channel = launcher.getChannel();
                if (channel == null) {
                    output = null;
                    listener.getLogger().println(Messages.scriptExecutionFailed(this.scriptId) + " - " + Messages.agent_no_channel());
                } else {
                    output = channel.call((Callable)new GroovyScript(script.getScriptText(), expandedParams, true, (TaskListener)listener));
                }
            }
            isOk = !Boolean.FALSE.equals(output);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(Messages.scriptExecutionFailed(this.scriptId) + " - " + e.getMessage());
            e.printStackTrace(listener.getLogger());
            Thread.currentThread().interrupt();
        }
        catch (IOException | MacroEvaluationException e) {
            listener.getLogger().println(Messages.scriptExecutionFailed(this.scriptId) + " - " + e.getMessage());
            e.printStackTrace(listener.getLogger());
        }
        return isOk;
    }

    private static String generateBuilderId() {
        return System.currentTimeMillis() + "_" + CURRENT_ID.addAndGet(1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptlerBuilder that = (ScriptlerBuilder)o;
        return Objects.equals(this.propagateParams, that.propagateParams) && Objects.equals(this.builderId, that.builderId) && Objects.equals(this.scriptId, that.scriptId) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.propagateParams, this.builderId, this.scriptId, this.parameters);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Jenkins.get().hasPermission(ScriptlerPermissions.RUN_SCRIPTS);
        }

        @NonNull
        public String getDisplayName() {
            return Messages.builder_name();
        }

        public Permission getRequiredPermission() {
            return ScriptlerPermissions.RUN_SCRIPTS;
        }

        public ScriptlerBuilder newInstance(StaplerRequest2 req, JSONObject formData) {
            Map<String, String> errors;
            ScriptlerBuilder builder = null;
            String builderId = formData.optString(ScriptlerBuilder.BUILDER_ID);
            String id = formData.optString("scriptlerScriptId");
            if (id != null && !id.isBlank()) {
                boolean inPropagateParams = formData.getBoolean("propagateParams");
                List<Parameter> params = UIHelper.extractParameters(formData);
                builder = new ScriptlerBuilder(builderId, id, inPropagateParams, params);
            }
            if (builder != null && !(errors = builder.checkGenericData()).isEmpty()) {
                throw new MultipleErrorFormValidation(errors);
            }
            if (builder == null) {
                builder = new ScriptlerBuilder(builderId, null, false, Collections.emptyList());
            }
            return builder.recreateBuilderWithBuilderIdIfRequired();
        }

        public List<Script> getScripts() {
            Set<Script> scripts = this.getConfig().getScripts();
            ArrayList<Script> scriptsForBuilder = new ArrayList<Script>();
            for (Script script : scripts) {
                if (!script.nonAdministerUsing) continue;
                scriptsForBuilder.add(script);
            }
            scriptsForBuilder.sort(Script.COMPARATOR_BY_NAME);
            return scriptsForBuilder;
        }

        private ScriptlerManagement getScriptler() {
            return (ScriptlerManagement)((Object)ExtensionList.lookupSingleton(ScriptlerManagement.class));
        }

        private ScriptlerConfiguration getConfig() {
            return this.getScriptler().getConfiguration();
        }

        @JavaScriptMethod
        public JSONArray getParameters(String scriptlerScriptId) {
            Script script = this.getConfig().getScriptById(scriptlerScriptId);
            if (script != null) {
                return JSONArray.fromObject(script.getParameters());
            }
            return null;
        }
    }

    private static class MultipleErrorFormValidation
    extends RuntimeException
    implements HttpResponse {
        private final Map<String, String> fieldToMessage;

        public MultipleErrorFormValidation(Map<String, String> fieldToMessage) {
            this.fieldToMessage = fieldToMessage;
        }

        private String getAggregatedMessage() {
            return this.buildMessages().collect(Collectors.joining(", "));
        }

        private Stream<String> buildMessages() {
            return this.fieldToMessage.entrySet().stream().map(error -> (String)error.getKey() + ": " + (String)error.getValue());
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            if (FormApply.isApply((StaplerRequest2)req)) {
                String script = this.buildMessages().map(QuotedStringTokenizer::quote).collect(Collectors.joining(""));
                FormApply.showNotification((String)script, (FormApply.NotificationType)FormApply.NotificationType.ERROR).generateResponse(req, rsp, node);
            } else {
                new Failure(this.getAggregatedMessage()).generateResponse(req, rsp, node);
            }
        }
    }

    public static final class ConverterImpl
    extends XStream2.PassthruConverter<ScriptlerBuilder> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(ScriptlerBuilder obj, UnmarshallingContext context) {
            Map<String, String> errors = obj.checkGenericData();
            if (!errors.isEmpty()) {
                ConversionException conversionException = new ConversionException("Validation failed");
                errors.forEach((arg_0, arg_1) -> ((ConversionException)conversionException).add(arg_0, arg_1));
                throw new CriticalXStreamException((XStreamException)conversionException);
            }
        }
    }
}

