/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final Set<String> PROPERTY_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("name", "value")));
    private final String name;
    private final String value;

    public Parameter(JSONObject object) {
        Set keys = object.keySet();
        if (!PROPERTY_NAMES.equals(keys)) {
            throw new IllegalArgumentException("Provided JSONObject does not appear to be a Parameter");
        }
        this.name = object.getString(NAME);
        this.value = object.getString(VALUE);
    }

    @DataBoundConstructor
    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.name, parameter.name) && Objects.equals(this.value, parameter.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

