/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;

public class SyncUtil {
    private static final Logger LOGGER = Logger.getLogger(SyncUtil.class.getName());

    private SyncUtil() {
    }

    public static void syncDirWithCfg(File scriptDirectory, ScriptlerConfiguration cfg) throws IOException {
        List<File> availablePhysicalScripts = SyncUtil.getAvailableScripts(scriptDirectory);
        for (File file : availablePhysicalScripts) {
            if (cfg.getScriptById(file.getName()) != null) continue;
            ScriptInfo info = ScriptHelper.extractScriptInfo(FileUtils.readFileToString((File)file, (String)"UTF-8"));
            if (info != null) {
                List<String> paramList = info.getParameters();
                Parameter[] parameters = new Parameter[paramList.size()];
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = new Parameter(paramList.get(i), null);
                }
                cfg.addOrReplace(new Script(file.getName(), info.getName(), info.getComment(), false, parameters, false));
                continue;
            }
            cfg.addOrReplace(new Script(file.getName(), file.getName(), Messages.script_loaded_from_directory(), false, null, false));
        }
        HashSet<Script> unavailableScripts = new HashSet<Script>();
        for (Script s : cfg.getScripts()) {
            if (new File(scriptDirectory, s.getScriptPath()).exists()) {
                s.setAvailable(true);
                continue;
            }
            Script unavailableScript = new Script(s.getId(), s.comment, false, false, false);
            unavailableScript.setParameters(s.getParameters());
            unavailableScripts.add(unavailableScript);
            LOGGER.info("for repo '" + scriptDirectory.getAbsolutePath() + "' " + s + " is not available!");
        }
        for (Script script : unavailableScripts) {
            cfg.addOrReplace(script);
        }
    }

    private static List<File> getAvailableScripts(File scriptDirectory) throws IOException {
        LOGGER.log(Level.FINE, "Listing files of {0}", scriptDirectory.getAbsoluteFile());
        File[] scriptFiles = scriptDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".groovy");
            }
        });
        List<File> fileList = scriptFiles == null ? new ArrayList<File>() : Arrays.asList(scriptFiles);
        return fileList;
    }
}

