/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import com.thoughtworks.xstream.XStream;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.ScriptlerPluginImpl;
import org.jenkinsci.plugins.scriptler.config.NamedResource;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptSet;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.util.ByIdSorter;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class ScriptlerConfiguration
extends ScriptSet
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerConfiguration.class.getName());
    @Deprecated
    private transient List<CatalogInfo> catalogInfos = new ArrayList<CatalogInfo>();
    private boolean disbableRemoteCatalog = false;
    @Deprecated
    private boolean allowRunScriptPermission = false;
    @Deprecated
    private boolean allowRunScriptEdit = false;
    private static volatile transient ScriptlerConfiguration cfg = null;
    private static final XStream XSTREAM = new XStream2();

    public ScriptlerConfiguration(SortedSet<Script> scripts) {
        if (scripts != null) {
            this.scriptSet = scripts;
        }
    }

    public synchronized void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        ScriptlerConfiguration.getXmlFile().write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)ScriptlerConfiguration.getXmlFile());
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(ScriptlerManagement.getScriptlerHomeDirectory(), "scriptler.xml"));
    }

    @Nonnull
    public static ScriptlerConfiguration load() throws IOException {
        XmlFile f = ScriptlerConfiguration.getXmlFile();
        if (f.exists()) {
            ScriptlerConfiguration sc = (ScriptlerConfiguration)f.read();
            TreeSet<NamedResource> sorted = new TreeSet<NamedResource>(new ByIdSorter());
            sorted.addAll(sc.getScripts());
            sc.setScripts(sorted);
            return sc;
        }
        return new ScriptlerConfiguration(new TreeSet<NamedResource>(new ByIdSorter()));
    }

    public static ScriptlerConfiguration getConfiguration() {
        if (cfg == null) {
            try {
                cfg = ScriptlerConfiguration.load();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to load scriptler configuration", e);
            }
        }
        return cfg;
    }

    public boolean isDisbableRemoteCatalog() {
        return this.disbableRemoteCatalog;
    }

    public void setDisbableRemoteCatalog(boolean disbableRemoteCatalog) {
        this.disbableRemoteCatalog = disbableRemoteCatalog;
    }

    public void setAllowRunScriptEdit(boolean allowRunScriptEdit) {
        this.allowRunScriptEdit = allowRunScriptEdit;
    }

    public void setAllowRunScriptPermission(boolean allowRunScriptPermission) {
        this.allowRunScriptPermission = allowRunScriptPermission;
    }

    public boolean isAllowRunScriptEdit() {
        return this.allowRunScriptEdit;
    }

    public boolean isAllowRunScriptPermission() {
        return this.allowRunScriptPermission;
    }

    @Restricted(value={DoNotUse.class})
    public List<ScriptAndApproved> getSortedScripts() {
        ArrayList<Script> sortedScripts = Jenkins.getInstance().hasPermission(ScriptlerPluginImpl.CONFIGURE) ? new ArrayList<Script>(this.getScripts()) : new ArrayList<Script>(this.getUserScripts());
        Collections.sort(sortedScripts, Script.COMPARATOR_BY_NAME);
        ArrayList<ScriptAndApproved> result = new ArrayList<ScriptAndApproved>(sortedScripts.size());
        for (Script script : sortedScripts) {
            Script scriptWithSrc = ScriptHelper.getScript(script.getId(), true);
            Boolean approved = null;
            if (scriptWithSrc != null && scriptWithSrc.script != null) {
                approved = ScriptHelper.isApproved(scriptWithSrc.script, false);
            }
            result.add(new ScriptAndApproved(script, approved));
        }
        return result;
    }

    static {
        XSTREAM.alias("scriptler", ScriptlerConfiguration.class);
        XSTREAM.alias("script", Script.class);
        XSTREAM.alias("catalog", CatalogInfo.class);
        XSTREAM.alias("parameter", Parameter.class);
        XSTREAM.alias("org.jvnet.hudson.plugins.scriptler.util.ByNameSorter", ByIdSorter.class);
    }

    @Restricted(value={NoExternalUse.class})
    public static class ScriptAndApproved {
        private Script script;
        private Boolean approved;

        private ScriptAndApproved(Script script, Boolean approved) {
            this.script = script;
            this.approved = approved;
        }

        public Script getScript() {
            return this.script;
        }

        public Boolean getApproved() {
            return this.approved;
        }
    }
}

