/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagment;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;

public class ScriptHelper {
    private static final Logger LOGGER = Logger.getLogger(ScriptHelper.class.getName());
    private static final Pattern SCRIPT_META_PATTERN = Pattern.compile(".*BEGIN META(.+?)END META.*", 32);
    private static final Map<String, Class<?>> JSON_CLASS_MAPPING = new HashMap();

    public static Script getScript(String id, boolean withSrc) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        Script s = ScriptlerConfiguration.getConfiguration().getScriptById(id);
        if (withSrc) {
            try {
                File scriptSrc = new File(ScriptlerManagment.getScriptDirectory(), s.getScriptPath());
                FileReader reader = new FileReader(scriptSrc);
                String src = IOUtils.toString((Reader)reader);
                s.setScript(src);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, Messages.scriptSourceNotFound(id), e);
            }
        }
        return s;
    }

    public static String runScript(String[] slaves, String scriptTxt, Parameter[] parameters) throws IOException, ServletException {
        StringBuffer output = new StringBuffer();
        for (String slave : slaves) {
            LOGGER.log(Level.FINE, "here is the node -> " + slave);
            output.append("___________________________________________\n");
            output.append("[" + slave + "]:\n");
            output.append(ScriptHelper.runScript(slave, scriptTxt, parameters));
        }
        output.append("___________________________________________\n");
        return output.toString();
    }

    public static String runScript(String node, String scriptTxt, Parameter[] parameters) throws IOException, ServletException {
        Object output = "[no output]";
        ByteArrayOutputStream sos = new ByteArrayOutputStream();
        if (node != null && scriptTxt != null) {
            try {
                Computer comp = Hudson.getInstance().getComputer(node);
                output = comp == null && "(master)".equals(node) ? Jenkins.MasterComputer.localChannel.call((Callable)new GroovyScript(scriptTxt, parameters, false, (TaskListener)new StreamTaskListener((OutputStream)sos))) : (comp == null ? Messages.node_not_found(node) + "\n" : (comp.getChannel() == null ? Messages.node_not_online(node) + "\n" : comp.getChannel().call((Callable)new GroovyScript(scriptTxt, parameters, false, (TaskListener)new StreamTaskListener((OutputStream)sos)))));
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return sos.toString();
    }

    public static ScriptInfo extractScriptInfo(String fullScriptBody) {
        Matcher matcher = SCRIPT_META_PATTERN.matcher(fullScriptBody);
        if (matcher.find()) {
            String group = matcher.group(1);
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)group.trim());
            return (ScriptInfo)JSONObject.toBean((JSONObject)json, ScriptInfo.class, JSON_CLASS_MAPPING);
        }
        return null;
    }

    static {
        JSON_CLASS_MAPPING.put("authors", ScriptInfo.Author.class);
        JSON_CLASS_MAPPING.put("parameters", Parameter.class);
    }
}

