/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import groovy.lang.GroovyShell;
import hudson.model.TaskListener;
import hudson.remoting.DelegatingCallable;
import java.io.PrintWriter;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScript
implements DelegatingCallable<Object, RuntimeException> {
    private static final long serialVersionUID = 1L;
    private final String script;
    private final Parameter[] parameters;
    private final boolean failWithException;
    private final TaskListener listener;
    private transient ClassLoader cl;
    private static final String PW_PARAM_VARIABLE = "out";

    public GroovyScript(String script, Parameter[] parameters, boolean failWithException, TaskListener listener) {
        this.script = script;
        this.parameters = parameters;
        this.failWithException = failWithException;
        this.listener = listener;
        this.cl = this.getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return Jenkins.getInstance().getPluginManager().uberClassLoader;
    }

    public Object call() throws RuntimeException {
        if (this.cl == null) {
            this.cl = Thread.currentThread().getContextClassLoader();
        }
        PrintWriter pw = new PrintWriter(this.listener.getLogger());
        GroovyShell shell = new GroovyShell(this.cl);
        for (Parameter param : this.parameters) {
            String paramName = param.getName();
            if (PW_PARAM_VARIABLE.equals(paramName)) {
                pw.write(Messages.skipParamter(PW_PARAM_VARIABLE));
                continue;
            }
            shell.setVariable(paramName, (Object)param.getValue());
        }
        shell.setVariable(PW_PARAM_VARIABLE, (Object)this.listener.getLogger());
        try {
            Object output = shell.evaluate(this.script);
            if (output != null) {
                pw.println(Messages.resultPrefix() + " " + output);
                return output;
            }
            return "";
        }
        catch (Throwable t) {
            if (this.failWithException) {
                throw new ScriptlerExecutionException(t);
            }
            t.printStackTrace(pw);
            return Boolean.FALSE;
        }
    }

    private static final class ScriptlerExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScriptlerExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

