/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import groovy.lang.GroovyShell;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.remoting.Callable;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.VirtualChannel;
import hudson.util.RemotingDiagnostics;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagment;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;

public class ScriptHelper {
    private static final Logger LOGGER = Logger.getLogger(ScriptHelper.class.getName());

    public static Script getScript(String id, boolean withSrc) {
        Script s = ScriptlerConfiguration.getConfiguration().getScriptById(id);
        File scriptSrc = new File(ScriptlerManagment.getScriptDirectory(), id);
        if (withSrc) {
            try {
                FileReader reader = new FileReader(scriptSrc);
                String src = IOUtils.toString((Reader)reader);
                s.setScript(src);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "not able to load sources for script [" + id + "]", e);
            }
        }
        return s;
    }

    public static String runScript(String[] slaves, String scriptTxt, Parameter[] parameters) throws IOException, ServletException {
        StringBuffer output = new StringBuffer();
        for (String slave : slaves) {
            LOGGER.log(Level.FINE, "here is the node -> " + slave);
            output.append("___________________________________________\n");
            output.append("[" + slave + "]:\n");
            output.append(ScriptHelper.runScript(slave, scriptTxt, parameters));
        }
        output.append("___________________________________________\n");
        return output.toString();
    }

    public static String runScript(String node, String scriptTxt, Parameter[] parameters) throws IOException, ServletException {
        String output = "[no output]";
        if (node != null && scriptTxt != null) {
            try {
                Computer comp = Hudson.getInstance().getComputer(node);
                output = comp == null && "(master)".equals(node) ? RemotingDiagnostics.executeGroovy((String)scriptTxt, (VirtualChannel)Jenkins.MasterComputer.localChannel) : (comp == null ? Messages.node_not_found(node) + "\n" : (comp.getChannel() == null ? Messages.node_not_online(node) + "\n" : (String)comp.getChannel().call((Callable)new GroovyScript(scriptTxt, parameters))));
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return output;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroovyScript
    implements DelegatingCallable<String, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final String script;
        private final Parameter[] parameters;
        private transient ClassLoader cl;

        private GroovyScript(String script, Parameter[] parameters) {
            this.script = script;
            this.parameters = parameters;
            this.cl = this.getClassLoader();
        }

        public ClassLoader getClassLoader() {
            return Jenkins.getInstance().getPluginManager().uberClassLoader;
        }

        public String call() throws RuntimeException {
            if (this.cl == null) {
                this.cl = Thread.currentThread().getContextClassLoader();
            }
            GroovyShell shell = new GroovyShell(this.cl);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            for (Parameter param : this.parameters) {
                String paramName = param.getName();
                if ("out".equals(paramName)) {
                    pw.write("skipping parameter 'out' this name is used inernal, please rename!");
                    continue;
                }
                shell.setVariable(paramName, (Object)param.getValue());
            }
            shell.setVariable("out", (Object)pw);
            try {
                Object output = shell.evaluate(this.script);
                if (output != null) {
                    pw.println("Result: " + output);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
            }
            return out.toString();
        }
    }
}

