/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.share.gh;

import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.share.gh.CentralScriptJsonCatalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(ordinal=10.0)
public class GHCatalog
extends ScriptInfoCatalog<ScriptInfo> {
    private static final Logger LOGGER = Logger.getLogger(GHCatalog.class.getName());
    public static final String REPO_BASE = "https://github.com/jenkinsci/jenkins-scripts/tree/master/scriptler";
    public static final String DOWNLOAD_URL = "https://raw.github.com/jenkinsci/jenkins-scripts/master/scriptler/{1}";
    public static final CatalogInfo CATALOG_INFO = new CatalogInfo("gh", "https://github.com/jenkinsci/jenkins-scripts/tree/master/scriptler", "https://github.com/jenkinsci/jenkins-scripts/tree/master/scriptler", "https://raw.github.com/jenkinsci/jenkins-scripts/master/scriptler/{1}");

    @Override
    public List<ScriptInfo> getEntries() {
        try {
            return Arrays.asList(((CentralScriptJsonCatalog)((Object)CentralScriptJsonCatalog.all().get(CentralScriptJsonCatalog.class))).toList().list);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "not abe to load script infos from GH", e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getDisplayName() {
        return "GitHub";
    }

    @Override
    public ScriptInfo getEntryById(String id) {
        for (ScriptInfo info : this.getEntries()) {
            if (!id.equals(info.getId())) continue;
            return info;
        }
        return null;
    }

    @Override
    public CatalogInfo getInfo() {
        return CATALOG_INFO;
    }

    @Override
    public String getScriptSource(ScriptInfo scriptInfo) {
        try {
            String scriptUrl = CATALOG_INFO.getReplacedDownloadUrl(scriptInfo.getName(), scriptInfo.getId());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.copyStreamAndClose((InputStream)ProxyConfiguration.open((URL)new URL(scriptUrl)).getInputStream(), (OutputStream)out);
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "not abe to load script sources from GH for: " + scriptInfo, e);
            return null;
        }
    }
}

