/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.scm.api.SCM2;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.impl.mock.MockChangeRequestFlags;
import jenkins.scm.impl.mock.MockChangeRequestSCMHead;
import jenkins.scm.impl.mock.MockChangeRequestSCMRevision;
import jenkins.scm.impl.mock.MockSCMChangeLogSet;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMRepositoryBrowser;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.mock.MockTagSCMHead;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.xml.sax.SAXException;

public class MockSCM
extends SCM2
implements Serializable {
    private final String controllerId;
    private final String repository;
    private final SCMHead head;
    private final SCMRevision revision;
    private transient MockSCMController controller;

    @DataBoundConstructor
    public MockSCM(String controllerId, String repository, String head, String revision) {
        revision = Util.fixEmptyAndTrim((String)revision);
        this.controllerId = controllerId;
        this.repository = repository;
        Matcher m = Pattern.compile("CR-(\\d+)(-[a-zA-Z]+)?").matcher(head);
        if (m.matches()) {
            int number = Integer.parseInt(m.group(1));
            String target = null;
            String targetRevision = null;
            Set<MockChangeRequestFlags> flags = null;
            try {
                target = this.controller().getTarget(repository, number);
                targetRevision = this.controller().getRevision(repository, target);
                flags = this.controller().getFlags(repository, number);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ChangeRequestCheckoutStrategy strategy = ChangeRequestCheckoutStrategy.HEAD;
            String strategyStr = m.group(2);
            if (StringUtils.isNotBlank((CharSequence)strategyStr)) {
                for (ChangeRequestCheckoutStrategy s : ChangeRequestCheckoutStrategy.values()) {
                    if (!strategyStr.equals("-" + s.name().toLowerCase(Locale.ENGLISH))) continue;
                    strategy = s;
                    break;
                }
            }
            MockChangeRequestSCMHead h = new MockChangeRequestSCMHead((SCMHeadOrigin)(flags == null || !flags.contains((Object)MockChangeRequestFlags.FORK) ? SCMHeadOrigin.DEFAULT : new SCMHeadOrigin.Fork("fork")), number, target, strategy, StringUtils.isNotBlank((CharSequence)strategyStr));
            this.head = h;
            this.revision = new MockChangeRequestSCMRevision(h, new MockSCMRevision(h.getTarget(), targetRevision), revision);
        } else if (head.startsWith("TAG:")) {
            long timestamp = 0L;
            try {
                timestamp = this.controller().getTagTimestamp(repository, head.substring(4));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.head = new MockTagSCMHead(head.substring(4), timestamp);
            this.revision = revision == null ? null : new MockSCMRevision(this.head, revision);
        } else {
            this.head = new MockSCMHead(head);
            this.revision = revision == null ? null : new MockSCMRevision(this.head, revision);
        }
    }

    public MockSCM(MockSCMSource config, SCMHead head, SCMRevision revision) {
        this.controllerId = config.getControllerId();
        this.repository = config.getRepository();
        this.head = head;
        this.revision = revision;
    }

    public MockSCM(MockSCMController controller, String repository, SCMHead head, SCMRevision revision) {
        this.controllerId = controller.getId();
        this.controller = controller;
        this.repository = repository;
        this.revision = revision;
        this.head = head;
    }

    public String getControllerId() {
        return this.controllerId;
    }

    private MockSCMController controller() {
        if (this.controller == null) {
            this.controller = MockSCMController.lookup(this.controllerId);
        }
        return this.controller;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getHead() {
        if (this.head instanceof MockChangeRequestSCMHead) {
            return "CR-" + ((MockChangeRequestSCMHead)this.head).getNumber();
        }
        if (this.head instanceof MockTagSCMHead) {
            return "TAG:" + this.head.getName();
        }
        return this.head.getName();
    }

    public String getRevision() {
        if (this.revision instanceof MockSCMRevision) {
            return ((MockSCMRevision)this.revision).getHash();
        }
        if (this.revision instanceof MockChangeRequestSCMRevision) {
            return ((MockChangeRequestSCMRevision)this.revision).getHash();
        }
        return null;
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public PollingResult compareRemoteRevisionWith(@NonNull Job<?, ?> project, @Nullable Launcher launcher, @Nullable FilePath workspace, @NonNull TaskListener listener, @NonNull SCMRevisionState baseline) throws IOException, InterruptedException {
        if (baseline instanceof MockSCMRevisionState) {
            String revision = this.revision instanceof MockSCMRevision ? ((MockSCMRevision)this.revision).getHash() : (this.revision instanceof MockChangeRequestSCMRevision ? ((MockChangeRequestSCMRevision)this.revision).getHash() : (this.head instanceof MockChangeRequestSCMHead ? this.controller().getRevision(this.repository, "change-request/" + ((MockChangeRequestSCMHead)this.head).getNumber()) : this.controller().getRevision(this.repository, this.head.getName())));
            if (((MockSCMRevisionState)baseline).getRevision().getHash().equals(revision)) {
                return PollingResult.NO_CHANGES;
            }
            return PollingResult.SIGNIFICANT;
        }
        return PollingResult.BUILD_NOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(@NonNull Run<?, ?> build, @NonNull Launcher launcher, @NonNull FilePath workspace, @NonNull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        String identifier = this.revision instanceof MockSCMRevision ? ((MockSCMRevision)this.revision).getHash() : (this.revision instanceof MockChangeRequestSCMRevision ? ((MockChangeRequestSCMRevision)this.revision).getHash() : this.head.getName());
        String hash = this.controller().checkout(workspace, this.repository, identifier);
        FileWriter writer = new FileWriter(changelogFile);
        try {
            Items.XSTREAM2.toXML(this.controller().log(this.repository, hash), (Writer)writer);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        build.addAction((Action)new MockSCMRevisionState(new MockSCMRevision(this.head, hash)));
    }

    public SCMRevisionState calcRevisionsFromBuild(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return (SCMRevisionState)build.getAction(MockSCMRevisionState.class);
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeLogParser(){

            public ChangeLogSet<? extends ChangeLogSet.Entry> parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
                List entries = (List)Items.XSTREAM2.fromXML(changelogFile);
                return new MockSCMChangeLogSet(build, browser, entries);
            }
        };
    }

    public String toString() {
        return "MockSCM{controllerId='" + this.controllerId + "', repository='" + this.repository + "', head=" + String.valueOf(this.head) + ", revision=" + String.valueOf(this.revision) + "}";
    }

    public static class MockSCMRevisionState
    extends SCMRevisionState {
        private final MockSCMRevision revision;

        public MockSCMRevisionState(MockSCMRevision revision) {
            this.revision = revision;
        }

        public MockSCMRevision getRevision() {
            return this.revision;
        }
    }

    @Symbol(value={"mockScm"})
    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<MockSCM> {
        public DescriptorImpl() {
            super(MockSCMRepositoryBrowser.class);
        }

        @NonNull
        public String getDisplayName() {
            return "Mock SCM";
        }

        public ListBoxModel doFillControllerIdItems() {
            ListBoxModel result = new ListBoxModel();
            for (MockSCMController c : MockSCMController.all()) {
                result.add(c.getId());
            }
            return result;
        }

        public ListBoxModel doFillRepositoryItems(@QueryParameter String controllerId) throws IOException {
            ListBoxModel result = new ListBoxModel();
            MockSCMController c = MockSCMController.lookup(controllerId);
            if (c != null) {
                for (String r : c.listRepositories()) {
                    result.add(r);
                }
            }
            return result;
        }

        public ListBoxModel doFillHeadItems(@QueryParameter String controllerId, @QueryParameter String repository) throws IOException {
            ListBoxModel result = new ListBoxModel();
            MockSCMController c = MockSCMController.lookup(controllerId);
            if (c != null) {
                for (String string : c.listBranches(repository)) {
                    result.add(string);
                }
                for (String string : c.listTags(repository)) {
                    result.add("TAG:" + string);
                }
                for (Integer n : c.listChangeRequests(repository)) {
                    result.add("CR-" + n);
                }
            }
            return result;
        }
    }
}

