/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.MethodUtils;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSourceCategory;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMTrait;

public abstract class SCMNavigator
extends AbstractDescribableImpl<SCMNavigator>
implements ExtensionPoint {
    public static final AlternativeUiTextProvider.Message<SCMNavigator> PRONOUN = new AlternativeUiTextProvider.Message();
    private transient String id;

    protected SCMNavigator() {
    }

    @NonNull
    public final String getId() {
        if (this.id == null) {
            this.id = MethodUtils.isAbstract(((Object)((Object)this)).getClass(), "id", new Class[0]) ? ((Object)((Object)this)).getClass().getName() + "::" + Util.getDigestOf((String)Items.XSTREAM.toXML((Object)this).replaceAll(" plugin=(('[^']+@[^']+')|(\"[^\"]+@[^\"]+\"))", "")) : ((Object)((Object)this)).getClass().getName() + "::" + this.id();
        }
        return this.id;
    }

    protected final void resetId() {
        this.id = null;
    }

    @NonNull
    protected abstract String id();

    public void setTraits(@CheckForNull List<SCMTrait<? extends SCMTrait<?>>> traits) {
    }

    @NonNull
    public List<SCMTrait<? extends SCMTrait<?>>> getTraits() {
        return Collections.emptyList();
    }

    public abstract void visitSources(@NonNull SCMSourceObserver var1) throws IOException, InterruptedException;

    public void visitSources(@NonNull SCMSourceObserver observer, @NonNull SCMSourceEvent<?> event) throws IOException, InterruptedException {
        this.visitSources(SCMSourceObserver.filter(observer, event.getSourceName()));
    }

    public void visitSources(@NonNull SCMSourceObserver observer, @NonNull SCMHeadEvent<?> event) throws IOException, InterruptedException {
        this.visitSources(SCMSourceObserver.filter(observer, event.getSourceName()));
    }

    public void visitSource(@NonNull String sourceName, @NonNull SCMSourceObserver observer) throws IOException, InterruptedException {
        this.visitSources(SCMSourceObserver.filter(observer, sourceName));
    }

    @NonNull
    public final Set<? extends SCMSourceCategory> getCategories() {
        Set<SCMSourceCategory> result = this.getDescriptor().getCategories();
        if (result.size() > 1 && MethodUtils.isOverridden(SCMNavigator.class, ((Object)((Object)this)).getClass(), "isCategoryEnabled", SCMSourceCategory.class)) {
            result = new LinkedHashSet<SCMSourceCategory>(result);
            result.removeIf(category -> !category.isUncategorized() && !this.isCategoryEnabled((SCMSourceCategory)category));
        }
        return result;
    }

    protected boolean isCategoryEnabled(@NonNull SCMSourceCategory category) {
        return true;
    }

    public SCMNavigatorDescriptor getDescriptor() {
        return (SCMNavigatorDescriptor)super.getDescriptor();
    }

    @CheckForNull
    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, (Object)((Object)this), (String)this.getDescriptor().getPronoun());
    }

    @NonNull
    public final List<Action> fetchActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @CheckForNull TaskListener listener) throws IOException, InterruptedException {
        return Util.fixNull(this.retrieveActions(owner, event, this.defaultListener(listener)));
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return Collections.emptyList();
    }

    @NonNull
    protected final TaskListener defaultListener(@CheckForNull TaskListener listener) {
        if (listener == null) {
            Level level;
            try {
                level = Level.parse(System.getProperty(((Object)((Object)this)).getClass().getName() + ".defaultListenerLevel", "FINE"));
            }
            catch (IllegalArgumentException e) {
                level = Level.FINE;
            }
            return new LogTaskListener(Logger.getLogger(((Object)((Object)this)).getClass().getName()), level);
        }
        return listener;
    }

    protected final void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public void afterSave(@NonNull SCMNavigatorOwner owner) {
    }
}

