/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.scm.api.Messages;
import jenkins.scm.api.SCMCategory;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import org.jvnet.localizer.Localizable;

public abstract class SCMHeadCategory
extends SCMCategory<SCMHead> {
    @NonNull
    public static List<SCMHeadCategory> collect(@NonNull Iterable<SCMSource> sources) {
        ArrayList<SCMHeadCategory> result = new ArrayList<SCMHeadCategory>();
        for (SCMSource source : sources) {
            block1: for (SCMHeadCategory sCMHeadCategory : source.getCategories()) {
                for (SCMHeadCategory added : result) {
                    if (sCMHeadCategory != added) continue;
                    continue block1;
                }
                result.add(sCMHeadCategory);
            }
        }
        return result;
    }

    public static List<SCMHeadCategory> addUncategorizedIfMissing(List<SCMHeadCategory> categories) {
        for (SCMHeadCategory category : categories) {
            if (!category.isUncategorized()) continue;
            return categories;
        }
        categories.add(UncategorizedSCMHeadCategory.DEFAULT);
        return categories;
    }

    public static SCMHeadCategory union(List<SCMHeadCategory> categories) {
        Localizable displayName;
        if (categories.isEmpty()) {
            throw new IllegalArgumentException("Cannot reduce an empty list");
        }
        if (categories.size() == 1) {
            return categories.get(0);
        }
        boolean includesCatchAll = false;
        final ArrayList<SCMHeadCategory> _categories = new ArrayList<SCMHeadCategory>(categories);
        for (SCMHeadCategory c : _categories) {
            if (!c.isUncategorized()) continue;
            includesCatchAll = true;
            break;
        }
        if (includesCatchAll) {
            displayName = SCMHeadCategory.toDisplayName(_categories);
            return new SCMHeadCategory(displayName){

                @Override
                @NonNull
                protected Localizable defaultDisplayName() {
                    return displayName;
                }

                @Override
                public boolean isMatch(@NonNull SCMHead instance) {
                    return true;
                }
            };
        }
        displayName = SCMHeadCategory.toDisplayName(_categories);
        String name = SCMHeadCategory.toShortUrl(_categories);
        return new SCMHeadCategory(name, displayName){

            @Override
            @NonNull
            protected Localizable defaultDisplayName() {
                return displayName;
            }

            @Override
            public boolean isMatch(@NonNull SCMHead instance) {
                for (SCMHeadCategory c : _categories) {
                    if (!c.isMatch(instance)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Map<String, SCMHeadCategory> simplify(Iterable<SCMHeadCategory> categories) {
        TreeMap<String, SCMHeadCategory> result = new TreeMap<String, SCMHeadCategory>();
        for (Map.Entry<String, List<SCMHeadCategory>> entry : SCMHeadCategory.group(categories).entrySet()) {
            result.put(entry.getKey(), SCMHeadCategory.union(entry.getValue()));
        }
        return result;
    }

    public static Map<String, SCMHeadCategory> collectAndSimplify(@NonNull Iterable<SCMSource> sources) {
        return SCMHeadCategory.simplify(SCMHeadCategory.addUncategorizedIfMissing(SCMHeadCategory.collect(sources)));
    }

    public SCMHeadCategory(@CheckForNull Localizable pronoun) {
        super(pronoun);
    }

    public SCMHeadCategory(@NonNull String urlName, @CheckForNull Localizable pronoun) {
        super(urlName, pronoun);
    }

    @Override
    @NonNull
    protected Localizable defaultDisplayName() {
        return Messages._SCMHeadCategory_DisplayName();
    }
}

