/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.BundleKeyStore;
import org.jenkinsci.plugins.saml.SamlEncryptionData;
import org.jenkinsci.plugins.saml.SamlFileResource;
import org.jenkinsci.plugins.saml.SamlPluginConfig;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public abstract class OpenSAMLWrapper<T> {
    private static final Logger LOG = Logger.getLogger(OpenSAMLWrapper.class.getName());
    private static final BundleKeyStore KS = new BundleKeyStore();
    protected SamlPluginConfig samlPluginConfig;
    protected StaplerRequest request;
    protected StaplerResponse response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T ret = null;
        try {
            LOG.finest("adapt TCCL");
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            thread.setContextClassLoader(InitializationService.class.getClassLoader());
            try {
                InitializationService.initialize();
                ret = this.process();
            }
            finally {
                LOG.finest("reset TCCL");
                thread.setContextClassLoader(loader);
            }
        }
        catch (InitializationException e) {
            LOG.log(Level.SEVERE, "Could not initialize opensaml service.", e);
            throw new IllegalStateException(e);
        }
        return ret;
    }

    protected abstract T process();

    protected WebContext createWebContext() {
        return new J2EContext((HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    protected SAML2Client createSAML2Client() {
        SAML2Configuration config = new SAML2Configuration();
        config.setIdentityProviderMetadataResource((Resource)new SamlFileResource(SamlSecurityRealm.getIDPMetadataFilePath()));
        config.setAuthnRequestBindingType(this.samlPluginConfig.getBinding());
        SamlEncryptionData encryptionData = this.samlPluginConfig.getEncryptionData();
        if (encryptionData != null) {
            config.setAuthnRequestSigned(encryptionData.isForceSignRedirectBindingAuthnRequest());
            config.setWantsAssertionsSigned(encryptionData.isWantsAssertionsSigned());
        } else {
            config.setAuthnRequestSigned(false);
            config.setWantsAssertionsSigned(false);
        }
        if (encryptionData != null && StringUtils.isNotBlank((String)encryptionData.getKeystorePath())) {
            config.setKeystorePath(encryptionData.getKeystorePath());
            config.setKeystorePassword(encryptionData.getKeystorePasswordPlainText());
            config.setPrivateKeyPassword(encryptionData.getPrivateKeyPasswordPlainText());
            config.setKeystoreAlias(encryptionData.getPrivateKeyAlias());
        } else {
            if (!KS.isValid()) {
                KS.init();
            }
            if (KS.isUsingDemoKeyStore()) {
                LOG.warning("Using bundled keystore : " + KS.getKeystorePath());
            }
            config.setKeystorePath(KS.getKeystorePath());
            config.setKeystorePassword(KS.getKsPassword());
            config.setPrivateKeyPassword(KS.getKsPkPassword());
            config.setKeystoreAlias(KS.getKsPkAlias());
        }
        config.setMaximumAuthenticationLifetime(this.samlPluginConfig.getMaximumAuthenticationLifetime().intValue());
        if (this.samlPluginConfig.getAdvancedConfiguration() != null) {
            config.setForceAuth(this.samlPluginConfig.getForceAuthn().booleanValue());
            if (this.samlPluginConfig.getSpEntityId() != null) {
                config.setServiceProviderEntityId(this.samlPluginConfig.getSpEntityId());
            }
            if (this.samlPluginConfig.getAuthnContextClassRef() != null) {
                config.setAuthnContextClassRef(this.samlPluginConfig.getAuthnContextClassRef());
                config.setComparisonType("exact");
            }
            if (this.samlPluginConfig.getNameIdPolicyFormat() != null) {
                config.setNameIdPolicyFormat(this.samlPluginConfig.getNameIdPolicyFormat());
            }
        }
        config.setForceServiceProviderMetadataGeneration(true);
        config.setServiceProviderMetadataResource((WritableResource)new SamlFileResource(SamlSecurityRealm.getSPMetadataFilePath()));
        SAML2Client saml2Client = new SAML2Client(config);
        saml2Client.setCallbackUrl(this.samlPluginConfig.getConsumerServiceUrl());
        saml2Client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        saml2Client.init();
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine(saml2Client.getServiceProviderMetadataResolver().getMetadata());
            }
            catch (IOException e) {
                LOG.fine("Is not possible to show the metadata : " + e.getMessage());
            }
        }
        return saml2Client;
    }
}

