/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.XmlFile;
import hudson.util.Secret;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.math.NumberUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class BundleKeyStore {
    public static final String PAC4J_DEMO_PASSWD = "pac4j-demo-passwd";
    public static final String PAC4J_DEMO_KEYSTORE = "resource:samlKeystore.jks";
    public static final String PAC4J_DEMO_ALIAS = "pac4j-demo";
    public static final String DEFAULT_KEY_ALIAS = "SAML-generated-keyPair";
    public static final String KEY_ALG = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String PROVIDER = "BC";
    public static final String KEY_VALIDITY_PROPERTY = BundleKeyStore.class.getName() + ".validity";
    public static final Long KEY_VALIDITY = 365L;
    private static final Logger LOG = Logger.getLogger(BundleKeyStore.class.getName());
    public static final String SAML_JENKINS_KEYSTORE_XML = "saml-jenkins-keystore.xml";
    public static final String SAML_JENKINS_KEYSTORE_JKS = "saml-jenkins-keystore.jks";
    private String keystorePath = "resource:samlKeystore.jks";
    private Secret ksPassword = Secret.fromString((String)"pac4j-demo-passwd");
    private Secret ksPkPassword = Secret.fromString((String)"pac4j-demo-passwd");
    private String ksPkAlias = "pac4j-demo";
    private Date dateValidity;
    private File keystore;
    private transient XmlFile config = null;

    public BundleKeyStore() {
        Jenkins jenkins = Jenkins.get();
        File jdir = jenkins.getRootDir();
        File configFile = new File(jdir, SAML_JENKINS_KEYSTORE_XML);
        this.config = new XmlFile(configFile);
        try {
            if (this.config.exists()) {
                this.config.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "It is not possible to write the configuration file " + this.config.getFile().getAbsolutePath(), e);
        }
    }

    public synchronized void init() {
        try {
            if (this.keystore == null || !this.keystoreFileExists()) {
                String jenkinsHome = Jenkins.get().getRootDir().getPath();
                this.keystore = Paths.get(jenkinsHome, SAML_JENKINS_KEYSTORE_JKS).toFile();
                this.keystorePath = "file:" + this.keystore.getPath();
            }
            if (PAC4J_DEMO_KEYSTORE.equals(this.ksPassword.getPlainText())) {
                this.ksPassword = Secret.fromString((String)this.generatePassword());
                this.ksPkPassword = Secret.fromString((String)this.generatePassword());
            }
            this.ksPkAlias = DEFAULT_KEY_ALIAS;
            KeyStore ks = this.loadKeyStore(this.keystore, this.ksPassword.getPlainText());
            KeyPair keypair = this.generate(2048);
            Certificate[] chain = this.createCertificateChain(keypair);
            ks.setKeyEntry(this.ksPkAlias, keypair.getPrivate(), this.ksPkPassword.getPlainText().toCharArray(), chain);
            this.saveKeyStore(this.keystore, ks, this.ksPassword.getPlainText());
            LOG.warning("Using automatic generated keystore : " + this.keystorePath);
            try {
                this.config.write((Object)this);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "It is not possible to write the configuration file " + this.config.getFile().getAbsolutePath(), e);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error accessing to saml-jenkins-keystore.jks keystore file, check the troubleshooting guide https://github.com/jenkinsci/saml-plugin/blob/master/doc/TROUBLESHOOTING.md", e);
            LOG.warning("Using bundled keystore : resource:samlKeystore.jks");
            this.ksPassword = Secret.fromString((String)PAC4J_DEMO_PASSWD);
            this.ksPkPassword = Secret.fromString((String)PAC4J_DEMO_PASSWD);
            this.keystorePath = PAC4J_DEMO_KEYSTORE;
            this.ksPkAlias = PAC4J_DEMO_ALIAS;
        }
    }

    private X509Certificate[] createCertificateChain(KeyPair keypair) throws IOException, CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException {
        X509Certificate[] chain = new X509Certificate[1];
        Long validity = NumberUtils.toLong((String)System.getProperty(KEY_VALIDITY_PROPERTY), (long)KEY_VALIDITY);
        chain[0] = this.generateCertificate("cn=SAML-jenkins", new Date(), TimeUnit.DAYS.toSeconds(validity), keypair);
        return chain;
    }

    private KeyStore initKeyStore(File keystore, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, password.toCharArray());
        this.saveKeyStore(keystore, ks, password);
        return ks;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="JENKINS-53692")
    private void saveKeyStore(File keystore, KeyStore ks, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileOutputStream fos = new FileOutputStream(keystore);){
            ks.store(fos, password.toCharArray());
        }
    }

    private KeyStore loadKeyStore(File keystore, String password) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream in = new FileInputStream(keystore);){
            ks.load(in, password.toCharArray());
        }
        catch (IOException e) {
            ks = this.initKeyStore(keystore, password);
        }
        return ks;
    }

    private String generatePassword() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstanceStrong();
        byte[] bytes = new byte[256];
        random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    private KeyPair generate(int keySize) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(KEY_ALG, PROVIDER);
        SecureRandom prng = new SecureRandom();
        keyGen.initialize(keySize, prng);
        return keyGen.generateKeyPair();
    }

    private X509Certificate generateCertificate(String dnName, Date notBefore, long validity, KeyPair keyPair) throws CertIOException, OperatorCreationException, CertificateException, NoSuchAlgorithmException {
        Date notAfter;
        X500Name dn = new X500Name(dnName);
        this.dateValidity = notAfter = new Date(notBefore.getTime() + validity * 1000L);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(dn, new BigInteger(160, new SecureRandom()), notBefore, notAfter, dn, keyPair.getPublic());
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keyPair.getPublic()));
        ASN1Encodable[] subjectAltNAmes = new ASN1Encodable[]{new GeneralName(2, dnName)};
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)GeneralNames.getInstance((Object)new DERSequence(subjectAltNAmes)));
        X509CertificateHolder certHldr = builder.build(new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).build(keyPair.getPrivate()));
        return new JcaX509CertificateConverter().getCertificate(certHldr);
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKsPassword() {
        return this.ksPassword.getPlainText();
    }

    public String getKsPkPassword() {
        return this.ksPkPassword.getPlainText();
    }

    public String getKsPkAlias() {
        return this.ksPkAlias;
    }

    public boolean isUsingDemoKeyStore() {
        return PAC4J_DEMO_KEYSTORE.equals(this.keystorePath);
    }

    public synchronized boolean isValid() {
        boolean notExpired = false;
        boolean fileExists = this.keystoreFileExists();
        boolean keysExists = false;
        if (this.dateValidity != null) {
            Calendar validity = Calendar.getInstance();
            validity.setTime(this.dateValidity);
            boolean bl = notExpired = Calendar.getInstance().compareTo(validity) <= 0;
        }
        if (fileExists) {
            try {
                KeyStore ks = this.loadKeyStore(this.keystore, this.ksPassword.getPlainText());
                keysExists = ks.getKey(this.ksPkAlias, this.ksPkPassword.getPlainText().toCharArray()) != null;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                LOG.log(Level.WARNING, "THe keystore is not accessible", e);
                keysExists = false;
            }
        }
        return notExpired && fileExists && keysExists;
    }

    private boolean keystoreFileExists() {
        return this.keystore != null && this.keystore.exists() && this.keystore.canRead();
    }
}

