/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.model.AperiodicWork;
import hudson.model.AsyncAperiodicWork;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.IdpMetadataConfiguration;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;

@Extension
public class UpdateMetadataFromURLPeriodicWork
extends AsyncAperiodicWork {
    private static final Logger LOG = Logger.getLogger(UpdateMetadataFromURLPeriodicWork.class.getName());
    private boolean scheduleedOnce;

    public UpdateMetadataFromURLPeriodicWork() {
        super("Update IdP Metadata from URL PeriodicWork");
    }

    public long getRecurrencePeriod() {
        long ret = this.getConfiguredPeriod();
        if (ret == 0L) {
            ret = TimeUnit.MINUTES.toMillis(10L);
        } else if (!this.scheduleedOnce) {
            ret = 10000L;
        }
        this.scheduleedOnce = true;
        return ret;
    }

    private long getConfiguredPeriod() {
        SamlSecurityRealm samlSecurityRealm;
        IdpMetadataConfiguration config;
        long ret = 0L;
        Jenkins j = Jenkins.getInstance();
        if (j.getSecurityRealm() instanceof SamlSecurityRealm && (config = (samlSecurityRealm = (SamlSecurityRealm)j.getSecurityRealm()).getIdpMetadataConfiguration()) != null && config.getPeriod() != null && StringUtils.isNotBlank((String)config.getUrl())) {
            ret = TimeUnit.MINUTES.toMillis(config.getPeriod());
        }
        return ret;
    }

    public AperiodicWork getNewInstance() {
        return new UpdateMetadataFromURLPeriodicWork();
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        if (this.getConfiguredPeriod() == 0L) {
            return;
        }
        Jenkins j = Jenkins.getInstance();
        if (j.getSecurityRealm() instanceof SamlSecurityRealm) {
            SamlSecurityRealm samlSecurityRealm = (SamlSecurityRealm)j.getSecurityRealm();
            try {
                samlSecurityRealm.getIdpMetadataConfiguration().updateIdPMetadata();
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

