/*
 * Decompiled with CFR 0.152.
 */
package com.waytta;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

class HttpCallable
extends MasterToSlaveCallable<String, IOException> {
    private static final long serialVersionUID = 1L;
    private String targetURL;
    private String urlParamsS;
    private String auth;

    public HttpCallable(String targetURL, JSONObject urlParams, String auth) {
        this.targetURL = targetURL;
        this.urlParamsS = null;
        if (urlParams != null) {
            this.urlParamsS = urlParams.toString();
        }
        this.auth = auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String call() throws IOException {
        Logger LOGGER = Logger.getLogger("com.waytta.saltstack");
        JSONObject urlParams = null;
        if (this.urlParamsS != null) {
            urlParams = (JSONObject)JSONSerializer.toJSON((Object)this.urlParamsS);
        }
        HttpURLConnection connection = null;
        JSONObject responseJSON = new JSONObject();
        try {
            int RETRYCOUNT = 3;
            int currentCount = 0;
            int responseCode = -1;
            while (currentCount++ < RETRYCOUNT) {
                try {
                    URL url = new URL(this.targetURL);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("Accept", "application/json");
                    connection.setUseCaches(false);
                    if (urlParams != null && !urlParams.isEmpty() || this.targetURL.contains("/hook")) {
                        connection.setDoOutput(true);
                        connection.setRequestProperty("Content-Type", "application/json");
                    }
                    connection.setConnectTimeout(30000);
                    if (this.auth != null && !this.auth.isEmpty()) {
                        connection.setRequestProperty("X-Auth-Token", this.auth);
                    }
                    if (urlParams != null && !urlParams.isEmpty() || this.targetURL.contains("/hook")) {
                        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                        wr.writeBytes(urlParams.toString());
                        wr.flush();
                        wr.close();
                    }
                    if ((responseCode = connection.getResponseCode()) == 408) {
                        throw new SocketTimeoutException("408 Response");
                    }
                    if (responseCode == 500) {
                        throw new SocketTimeoutException("500 Response");
                    }
                    break;
                }
                catch (SocketTimeoutException e) {
                    if (currentCount < RETRYCOUNT) {
                        LOGGER.log(Level.FINE, e.getMessage() + " encountered " + currentCount + " times, retrying.");
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    LOGGER.log(Level.FINE, e.getMessage() + " encountered " + currentCount + " times. Failing");
                }
            }
            if (responseCode < 200 || responseCode > 299) {
                String responseError = "";
                try {
                    InputStream err = connection.getErrorStream();
                    if (err != null) {
                        responseError = responseError + "HTTP ERROR: \n" + this.read(err) + "\n\n";
                        err.close();
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
                try {
                    InputStream str = connection.getInputStream();
                    if (str != null) {
                        responseError = responseError + "HTTP Response: \n" + this.read(str);
                        str.close();
                    }
                }
                catch (Exception str) {
                    // empty catch block
                }
                throw new IOException("Bad ResponseCode: " + connection.getResponseCode() + " " + connection.getResponseMessage() + "\n" + responseError);
            }
            InputStream is = connection.getInputStream();
            String responseText = this.read(is);
            responseJSON = (JSONObject)JSONSerializer.toJSON((Object)responseText);
            if (this.auth == null || this.auth.isEmpty()) {
                String serverHeader = "unknown";
                serverHeader = connection.getHeaderField("Server");
                responseJSON.element("server", (Object)serverHeader);
            }
            String string = responseJSON.toString();
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String read(InputStream stream) throws IOException {
        String line;
        BufferedReader rdr = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuffer response = new StringBuffer();
        while ((line = rdr.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        rdr.close();
        return response.toString();
    }
}

