/*
 * Decompiled with CFR 0.152.
 */
package com.waytta;

import com.waytta.HttpCallable;
import com.waytta.SaltException;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;

public class Builds {
    public static void addArgumentsToSaltFunction(String myarguments, JSONObject saltFunc) {
        if (myarguments.length() > 0) {
            String[] argItems;
            String equalsPattern = "\\\\\"|\\\\'|\"(?:\\\\\"|[^\"])*\"|'(?:\\\\'|[^'])*'|(=)";
            Pattern p = Pattern.compile(equalsPattern);
            JSONObject fullKwJSON = new JSONObject();
            for (String arg : argItems = myarguments.split("\\s+(?=(?:[^'\"]|'[^']*'|\"[^\"]*\")*$)")) {
                arg = arg.replaceAll("^\\s+|\\s+$", "");
                Boolean isKW = false;
                Matcher m = p.matcher(arg);
                while (m.find()) {
                    if (!StringUtils.isNotEmpty((String)m.group(1))) continue;
                    isKW = true;
                }
                arg = arg.replaceAll("(^')|(^\")|('$)|(\"$)", "");
                if (isKW.booleanValue()) {
                    String[] kwString = arg.split("=");
                    if (kwString.length > 2) {
                        String kwFull = "";
                        for (String kwItem : kwString) {
                            if (kwItem.equals(kwString[0])) continue;
                            if (kwItem.equals(kwString[1])) {
                                kwItem = kwItem.replaceAll("(^')|(^\")|('$)|(\"$)", "");
                                kwFull = kwFull + kwItem;
                                continue;
                            }
                            kwFull = kwFull + "=" + kwItem;
                        }
                        fullKwJSON.put(kwString[0], (Object)kwFull);
                        continue;
                    }
                    kwString[1] = kwString[1].replaceAll("(^')|(^\")|('$)|(\"$)", "");
                    try {
                        JSON kwJSON = JSONSerializer.toJSON((Object)kwString[1]);
                        fullKwJSON.element(kwString[0], (Object)kwJSON);
                    }
                    catch (JSONException e) {
                        if (Builds.isInteger(kwString[1])) {
                            fullKwJSON.put(kwString[0], (Object)Integer.parseInt(kwString[1]));
                            continue;
                        }
                        fullKwJSON.put(kwString[0], (Object)kwString[1]);
                    }
                    continue;
                }
                if (Builds.isInteger(arg)) {
                    saltFunc.accumulate("arg", Integer.parseInt(arg));
                    continue;
                }
                saltFunc.accumulate("arg", (Object)arg);
            }
            saltFunc.element("kwarg", (Map)fullKwJSON);
        }
    }

    private static boolean isInteger(String s) {
        boolean isInteger = false;
        try {
            Integer.parseInt(s);
            isInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return isInteger;
    }

    public static int returnedMinions(JSONArray saltReturn) {
        int numMinionsDone = 0;
        JSONObject resultObject = new JSONObject();
        resultObject = saltReturn.getJSONObject(0).getJSONObject("Result");
        Iterator rMinionKeys = resultObject.keys();
        while (rMinionKeys.hasNext()) {
            String key = (String)rMinionKeys.next();
            if (!(resultObject.get(key) instanceof JSONObject)) continue;
            ++numMinionsDone;
        }
        return numMinionsDone;
    }

    public static JSONArray returnData(JSONObject saltReturn, String netapi) {
        JSONArray returnArray = new JSONArray();
        returnArray = netapi.contains("TornadoServer") ? saltReturn.getJSONArray("return") : saltReturn.getJSONArray("info");
        return returnArray;
    }

    public static String getBlockingBuildJid(Launcher launcher, String myservername, String token, JSONObject saltFunc, TaskListener listener) throws IOException, InterruptedException, SaltException {
        String jid = null;
        JSONObject httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(myservername + "/minions", saltFunc, token)));
        JSONArray returnArray = httpResponse.getJSONArray("return");
        for (Object o : returnArray) {
            JSONObject line = (JSONObject)o;
            if (line.isEmpty()) {
                throw new SaltException("Missing JID: No minions matched target");
            }
            jid = line.getString("jid");
        }
        listener.getLogger().println("Running jid: " + jid);
        return jid;
    }

    public static JSONArray checkBlockingBuild(Launcher launcher, String myservername, String token, JSONObject saltFunc, TaskListener listener, int pollTime, int minionTimeout, String netapi, String jid) throws IOException, InterruptedException, SaltException {
        int numMinions = 0;
        int numMinionsDone = 0;
        JSONArray minionsArray = new JSONArray();
        JSONObject resultObject = new JSONObject();
        JSONArray httpArray = new JSONArray();
        JSONArray returnArray = new JSONArray();
        JSONObject httpResponse = new JSONObject();
        httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(myservername + "/jobs/" + jid, null, token)));
        httpArray = Builds.returnData(httpResponse, netapi);
        for (Object o : httpArray) {
            JSONObject line = (JSONObject)o;
            minionsArray = line.getJSONArray("Minions");
            resultObject = line.getJSONObject("Result");
        }
        numMinions = minionsArray.size();
        listener.getLogger().println("Waiting for " + numMinions + " minions");
        numMinionsDone = Builds.returnedMinions(httpArray);
        listener.getLogger().println(numMinionsDone + " minions are done");
        if (numMinionsDone < numMinions) {
            listener.getLogger().println("Will check status every " + pollTime + " seconds...");
        }
        while (numMinionsDone < numMinions) {
            try {
                Thread.sleep((long)pollTime * 1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InterruptedException();
            }
            httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(myservername + "/jobs/" + jid, null, token)));
            httpArray = Builds.returnData(httpResponse, netapi);
            numMinionsDone = Builds.returnedMinions(httpArray);
            boolean timeoutFail = true;
            if (minionTimeout < 0) {
                timeoutFail = false;
                minionTimeout *= -1;
            }
            if (numMinionsDone <= 0 || numMinionsDone >= numMinions) continue;
            try {
                listener.getLogger().println("Some minions returned. Waiting " + minionTimeout + " seconds");
                int numberChecks = minionTimeout / pollTime;
                int numberChecksRemain = minionTimeout % pollTime;
                for (int i = 0; i < numberChecks; ++i) {
                    httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(myservername + "/jobs/" + jid, null, token)));
                    httpArray = Builds.returnData(httpResponse, netapi);
                    numMinionsDone = Builds.returnedMinions(httpArray);
                    if (numMinionsDone >= numMinions) {
                        returnArray.clear();
                        returnArray.add((Object)httpArray);
                        return returnArray;
                    }
                    Thread.sleep((long)pollTime * 1000L);
                }
                if (numberChecksRemain > 0) {
                    Thread.sleep((long)numberChecksRemain * 1000L);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InterruptedException();
            }
            httpResponse = (JSONObject)JSONSerializer.toJSON((Object)launcher.getChannel().call((Callable)new HttpCallable(myservername + "/jobs/" + jid, null, token)));
            httpArray = Builds.returnData(httpResponse, netapi);
            numMinionsDone = Builds.returnedMinions(httpArray);
            if (numMinionsDone >= numMinions) continue;
            JSONArray respondedMinions = new JSONArray();
            Iterator rMinionKeys = httpArray.getJSONObject(0).getJSONObject("Result").keys();
            while (rMinionKeys.hasNext()) {
                String key = (String)rMinionKeys.next();
                respondedMinions.add((Object)key);
            }
            for (int i = 0; i < respondedMinions.size(); ++i) {
                minionsArray.discard(respondedMinions.get(i));
            }
            listener.error("Minions timed out:\n" + minionsArray.toString() + "\n\n");
            if (timeoutFail) {
                throw new SaltException(httpArray.getJSONObject(0).getJSONObject("Result").toString());
            }
            returnArray.clear();
            returnArray.add((Object)httpArray.getJSONObject(0).getJSONObject("Result"));
            return returnArray;
        }
        returnArray.clear();
        returnArray.add((Object)httpArray.getJSONObject(0).getJSONObject("Result"));
        return returnArray;
    }
}

