/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.model.Action;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.RundeckNotifier;
import org.kohsuke.stapler.export.Exported;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.RundeckClient;
import org.rundeck.api.domain.RundeckJob;

public class RundeckJobProjectLinkerAction
implements Action {
    private final String rundeckInstanceName;
    private final RundeckClient rundeck;
    private final RundeckJob rundeckJob;
    private final String rundeckJobUrl;

    public RundeckJobProjectLinkerAction(String rundeckInstanceName, RundeckClient rundeck, String rundeckJobId) throws RundeckApiException, IllegalArgumentException {
        if (rundeck == null) {
            throw new IllegalArgumentException("rundeckClient should not be null !");
        }
        this.rundeckInstanceName = rundeckInstanceName;
        this.rundeck = rundeck;
        this.rundeckJob = RundeckNotifier.RundeckDescriptor.findJob(rundeckJobId, rundeckInstanceName, rundeck);
        this.rundeckJobUrl = this.buildRundeckJobUrl();
    }

    private String buildRundeckJobUrl() {
        StringBuilder url = new StringBuilder();
        url.append(this.rundeck.getUrl());
        if (!StringUtils.endsWith((String)this.rundeck.getUrl(), (String)"/")) {
            url.append("/");
        }
        url.append("job/show/");
        url.append(this.rundeckJob.getId());
        return url.toString();
    }

    @Exported
    public RundeckJob getRundeckJob() {
        return this.rundeckJob;
    }

    public String getIconFileName() {
        return "/plugin/rundeck/images/rundeck_24x24.png";
    }

    public String getDisplayName() {
        return "Job: [" + this.rundeckJob.getProject() + "] " + this.rundeckJob.getName();
    }

    public String getUrlName() {
        return this.rundeckJobUrl;
    }

    public String getInstanceName() {
        return this.rundeckInstanceName;
    }
}

