/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class ParseJson {
    public static JsonElement clean(JsonElement elem) {
        if (elem.isJsonPrimitive()) {
            JsonPrimitive primitive = elem.getAsJsonPrimitive();
            if (primitive.isString()) {
                String cleaned = Jsoup.clean((String)primitive.getAsString(), (Safelist)Safelist.none());
                return new JsonPrimitive(cleaned);
            }
            return primitive;
        }
        if (elem.isJsonArray()) {
            JsonArray cleanArray = new JsonArray();
            for (JsonElement arrayElement : elem.getAsJsonArray()) {
                cleanArray.add(ParseJson.clean(arrayElement));
            }
            return cleanArray;
        }
        JsonObject obj = elem.getAsJsonObject();
        JsonObject clean = new JsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            clean.add(Jsoup.clean((String)((String)entry.getKey()), (Safelist)Safelist.none()), ParseJson.clean((JsonElement)entry.getValue()));
        }
        return clean;
    }
}

