/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck.client;

import hudson.AbortException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.RundeckInstance;
import org.jenkinsci.plugins.rundeck.client.RundeckClientUtil;
import org.jenkinsci.plugins.rundeck.client.RundeckManager;
import org.rundeck.client.RundeckClient;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.AbortResult;
import org.rundeck.client.api.model.ExecOutput;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobItem;
import org.rundeck.client.api.model.JobRun;
import org.rundeck.client.util.Client;
import retrofit2.Call;
import retrofit2.Response;

public class RundeckClientManager
implements RundeckManager {
    public static final Integer API_VERSION = 32;
    private RundeckInstance rundeckInstance;
    private Client<RundeckApi> client;

    public RundeckClientManager() {
    }

    public RundeckClientManager(RundeckInstance rundeckInstance) {
        this.rundeckInstance = rundeckInstance;
        this.buildClient();
    }

    @Override
    public RundeckInstance getRundeckInstance() {
        return this.rundeckInstance;
    }

    public void setRundeckInstance(RundeckInstance rundeckInstance) {
        this.rundeckInstance = rundeckInstance;
    }

    public Client<RundeckApi> getClient() {
        return this.client;
    }

    public void setClient(Client<RundeckApi> client) {
        this.client = client;
    }

    public void buildClient() {
        if (this.client == null) {
            RundeckClient.Builder builder = RundeckClient.builder().baseUrl(this.rundeckInstance.getUrl());
            if (this.rundeckInstance.getToken() != null && !this.rundeckInstance.getToken().getPlainText().isEmpty()) {
                builder.tokenAuth(this.rundeckInstance.getToken().getPlainText());
            }
            if (!StringUtils.isEmpty((String)this.rundeckInstance.getLogin()) && !StringUtils.isEmpty((String)this.rundeckInstance.getPassword().getPlainText())) {
                builder.passwordAuth(this.rundeckInstance.getLogin(), this.rundeckInstance.getPassword().getPlainText());
            }
            if (this.rundeckInstance.getApiVersion() != null) {
                builder.apiVersion(this.rundeckInstance.getApiVersion().intValue());
            }
            if (this.rundeckInstance.isSslCertificateTrustAllowSelfSigned()) {
                builder.insecureSSL(true);
            }
            this.client = builder.build();
        }
    }

    @Override
    public AbortResult abortExecution(String id) throws IOException {
        Call rundeckOutputCall = ((RundeckApi)this.client.getService()).abortExecution(id);
        Response abortResultResponse = rundeckOutputCall.execute();
        return (AbortResult)abortResultResponse.body();
    }

    @Override
    public ExecOutput getOutput(Long executionId, Long var2, Integer var3, Integer var4) throws IOException {
        return this.getOutput(executionId.toString(), var2, (long)var3, (long)var4);
    }

    @Override
    public ExecOutput getOutput(String executionId, Long var2, Long var3, Long var4) throws IOException {
        Call rundeckOutputCall = ((RundeckApi)this.client.getService()).getOutput(executionId, var2, var3, var4);
        Response execOutputResponse = rundeckOutputCall.execute();
        return (ExecOutput)execOutputResponse.body();
    }

    @Override
    public Execution getExecution(String id) throws IOException {
        Call callExecutions = ((RundeckApi)this.client.getService()).getExecution(id);
        Response executionResponse = callExecutions.execute();
        if (executionResponse.isSuccessful()) {
            return (Execution)executionResponse.body();
        }
        return null;
    }

    @Override
    public String findJobId(String project, String name, String groupPath) throws IOException {
        JobItem job = this.findJob(project, name, groupPath);
        if (job != null) {
            return job.getId();
        }
        return null;
    }

    @Override
    public JobItem findJob(String project, String name, String groupPath) throws IOException {
        Call listCall = ((RundeckApi)this.client.getService()).listJobs(project, name, groupPath, "", "");
        Response execute = listCall.execute();
        if (execute.isSuccessful()) {
            List body = (List)execute.body();
            if (body.size() == 0) {
                return null;
            }
            JobItem foundJob = null;
            Iterator iterator = body.iterator();
            while (iterator.hasNext()) {
                JobItem job;
                foundJob = job = (JobItem)iterator.next();
            }
            return foundJob;
        }
        return null;
    }

    @Override
    public JobItem getJob(String id) throws IOException {
        Call jobCall = ((RundeckApi)this.client.getService()).getJobInfo(id);
        Response scheduledJobItemResponse = jobCall.execute();
        return (JobItem)scheduledJobItemResponse.body();
    }

    @Override
    public Execution runExecution(String jobId, Properties options, Properties nodeFilters) throws IOException {
        HashMap<String, String> inputOptions = new HashMap<String, String>();
        for (String name : options.stringPropertyNames()) {
            inputOptions.put(name, options.getProperty(name));
        }
        String nodeFilterValues = RundeckClientUtil.parseNodeFilters(nodeFilters);
        JobRun jobRun = new JobRun();
        jobRun.setOptions(inputOptions);
        jobRun.setFilter(nodeFilterValues);
        Call callExecutions = ((RundeckApi)this.client.getService()).runJob(jobId, jobRun);
        Response executionResponse = callExecutions.execute();
        if (!executionResponse.isSuccessful()) {
            throw new AbortException("Error running the job : " + executionResponse.message());
        }
        Execution execution = (Execution)executionResponse.body();
        return execution;
    }

    @Override
    public boolean ping() throws IOException {
        Response result = ((RundeckApi)this.client.getService()).getPing().execute();
        return result.isSuccessful();
    }

    @Override
    public boolean testAuth() throws IOException {
        Response result = ((RundeckApi)this.client.getService()).systemInfo().execute();
        return result.isSuccessful();
    }

    public static enum ExecutionStatus {
        RUNNING("running"),
        SUCCEEDED("succeeded"),
        FAILED("failed"),
        ABORTED("aborted"),
        FAILED_WITH_RETRY("failed-with-retry"),
        TIMEDOUT("timedout");

        private String value;

        private ExecutionStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

