/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck.client;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobItem;

public class ExecutionData
extends Execution {
    Execution execution;

    public ExecutionData(Execution execution) {
        this.execution = execution;
        this.cloneExecution();
    }

    public Long getDurationInMillis() {
        if (this.execution.getDateStarted() == null || this.execution.getDateEnded() == null) {
            return null;
        }
        return this.execution.getDateEnded().unixtime - this.execution.getDateStarted().unixtime;
    }

    public Long getDurationInSeconds() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(durationInMillis)) : null;
    }

    public String getDuration() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? DurationFormatUtils.formatDurationWords((long)durationInMillis, (boolean)true, (boolean)true) : null;
    }

    public String getShortDuration() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? DurationFormatUtils.formatDurationHMS((long)durationInMillis) : null;
    }

    private void cloneExecution() {
        JobItem job;
        this.setStatus(this.execution.getStatus());
        this.setDateStarted(this.execution.getDateStarted());
        this.setDateEnded(this.execution.getDateEnded());
        this.setDescription(this.execution.getDescription());
        this.setFailedNodes(this.execution.getFailedNodes());
        this.setProject(this.execution.getProject());
        this.setSuccessfulNodes(this.execution.getSuccessfulNodes());
        this.setId(this.execution.getId());
        this.setServerUUID(this.execution.getServerUUID());
        this.setUser(this.execution.getUser());
        this.setArgstring(this.execution.getArgstring());
        if (this.isValidURL(this.execution.getHref())) {
            this.setHref(this.execution.getHref());
        }
        if (this.isValidURL(this.execution.getPermalink())) {
            this.setPermalink(this.execution.getPermalink());
        }
        if ((job = this.execution.getJob()) != null) {
            if (!this.isValidURL(job.getPermalink())) {
                job.setPermalink(null);
            }
            if (!this.isValidURL(job.getHref())) {
                job.setHref(null);
            }
            this.setJob(job);
        }
    }

    private boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

