/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jenkinsci.plugins.rundeck.RundeckNotifier;
import org.jenkinsci.plugins.rundeck.cache.RundeckJobCache;
import org.jenkinsci.plugins.rundeck.cache.RundeckJobCacheConfig;
import org.jenkinsci.plugins.rundeck.client.RundeckManager;
import org.rundeck.client.api.model.JobItem;

public class InMemoryRundeckJobCache
implements RundeckJobCache {
    private static final Logger log = Logger.getLogger(InMemoryRundeckJobCache.class.getName());
    private static final int RUNDECK_INSTANCE_CACHE_CONTAINER_EXPIRATION_IN_DAYS = 1;
    private final int cacheStatsDisplayHitThreshold;
    private final LoadingCache<String, Cache<String, JobItem>> rundeckJobInstanceAwareCache;
    private long hitCounter = 0L;

    public InMemoryRundeckJobCache(RundeckJobCacheConfig rundeckJobCacheConfig) {
        Objects.requireNonNull(rundeckJobCacheConfig);
        this.cacheStatsDisplayHitThreshold = rundeckJobCacheConfig.getCacheStatsDisplayHitThreshold();
        this.rundeckJobInstanceAwareCache = Caffeine.newBuilder().recordStats().expireAfterAccess(1L, TimeUnit.DAYS).build(rundeckInstanceName -> this.createJobCacheForRundeckInstance((String)rundeckInstanceName, rundeckJobCacheConfig));
    }

    private Cache<String, JobItem> createJobCacheForRundeckInstance(String rundeckInstanceName, RundeckJobCacheConfig rundeckJobCacheConfig) {
        log.info(String.format("Loading (GENERATING) jobs cache container for Rundeck instance %s", rundeckInstanceName));
        return Caffeine.newBuilder().recordStats().expireAfterAccess((long)rundeckJobCacheConfig.getAfterAccessExpirationInMinutes(), TimeUnit.MINUTES).maximumSize((long)rundeckJobCacheConfig.getMaximumSize()).build();
    }

    @Override
    public JobItem findJobById(String rundeckJobId, String rundeckInstanceName, RundeckManager rundeckInstance) {
        log.fine(String.format("Cached findJob request for jobId: %s (%s)", rundeckJobId, rundeckInstanceName));
        return this.findByJobIdInCacheOrAskServer(rundeckJobId, rundeckInstanceName, rundeckInstance);
    }

    @Override
    public String logAndGetStats() {
        return this.logStatsAndReturnsAsString();
    }

    private String logStatsAndReturnsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.rundeckJobInstanceAwareCache.estimatedSize() == 0L) {
            sb.append("Cache is empty");
        } else {
            for (Map.Entry instanceCacheEntries : this.rundeckJobInstanceAwareCache.asMap().entrySet()) {
                this.logCacheStats((String)instanceCacheEntries.getKey(), (Cache)instanceCacheEntries.getValue());
                sb.append(String.format("%s: %s", instanceCacheEntries.getKey(), ((Cache)instanceCacheEntries.getValue()).stats())).append("\n");
            }
        }
        this.logCacheStats("Meta", (Cache<String, ?>)this.rundeckJobInstanceAwareCache);
        return sb.toString();
    }

    @Override
    public void invalidate() {
        this.logStatsAndReturnsAsString();
        log.info("Rundeck job cache invalidation");
        this.rundeckJobInstanceAwareCache.invalidateAll();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private JobItem findByJobIdInCacheOrAskServer(String rundeckJobId, String rundeckInstanceName, RundeckManager rundeckInstance) {
        Cache rundeckJobCache = (Cache)this.rundeckJobInstanceAwareCache.get((Object)rundeckInstanceName);
        JobItem tmp = (JobItem)rundeckJobCache.get((Object)rundeckJobId, unused -> RundeckNotifier.RundeckDescriptor.findJobUncached(rundeckJobId, rundeckInstance));
        this.logCacheStatsIfAppropriate(rundeckInstanceName, (Cache<String, JobItem>)rundeckJobCache);
        return tmp;
    }

    private void logCacheStatsIfAppropriate(String instanceName, Cache<String, JobItem> jobCache) {
        if (this.cacheStatsDisplayHitThreshold <= 0) {
            return;
        }
        if (++this.hitCounter % (long)this.cacheStatsDisplayHitThreshold == 0L) {
            this.logCacheStats(instanceName, jobCache);
        }
    }

    private void logCacheStats(String instanceName, Cache<String, ?> jobCache) {
        log.info(String.format("%s: %s", instanceName, jobCache.stats()));
    }
}

