/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import hudson.model.AbstractProject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.rundeck.RundeckTrigger;
import org.jenkinsci.plugins.rundeck.client.ExecutionData;
import org.jenkinsci.plugins.rundeck.util.ParseJson;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.rundeck.client.api.model.Execution;

public class WebHookListener {
    static final String TOKEN = "rundeckTriggerToken";

    @RequirePOST
    public void doIndex(StaplerRequest request, StaplerResponse response) {
        try {
            String token = request.getHeader(TOKEN);
            Gson gson = new Gson();
            InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");
            JsonElement jsonElement = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            JsonElement jsonElementCleaned = ParseJson.clean(jsonElement);
            Execution execution = (Execution)gson.fromJson(jsonElementCleaned, Execution.class);
            ExecutionData executionSafeData = new ExecutionData(execution);
            response.setStatus(200);
            response.setContentType("text/plain");
            for (AbstractProject job : Jenkins.get().getAllItems(AbstractProject.class)) {
                RundeckTrigger trigger = (RundeckTrigger)job.getTrigger(RundeckTrigger.class);
                if (trigger == null || !trigger.shouldScheduleBuild(executionSafeData, token)) continue;
                RundeckTrigger.RundeckTriggerCheckResult result = trigger.validateExecution(executionSafeData);
                if (result.isValid()) {
                    response.getWriter().append("[\"Triggering:\" : \"" + job.getFullDisplayName() + "\"\n");
                    response.getWriter().append("\"Execution\" : \"" + execution.getJob().getName() + "\"]\n");
                    trigger.onNotification(executionSafeData);
                    continue;
                }
                response.getWriter().append("{\"Error:\" : \"" + result.getMessage() + "\"}");
                response.setStatus(400);
            }
        }
        catch (JsonSyntaxException e) {
            response.setStatus(400);
            response.setContentType("text/plain");
            try {
                response.getWriter().append(e.getMessage());
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Something failed!", e);
        }
    }
}

