/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.Secret;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.RundeckCause;
import org.jenkinsci.plugins.rundeck.RundeckInstance;
import org.jenkinsci.plugins.rundeck.RundeckInstanceBuilder;
import org.jenkinsci.plugins.rundeck.RundeckNotifier;
import org.jenkinsci.plugins.rundeck.client.ExecutionData;
import org.jenkinsci.plugins.rundeck.client.RundeckClientManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobItem;

public class RundeckTrigger
extends Trigger<AbstractProject<?, ?>> {
    private final Boolean filterJobs;
    private final List<String> jobsIdentifiers;
    private final List<String> executionStatuses;
    private final Secret token;

    @DataBoundConstructor
    public RundeckTrigger(Boolean filterJobs, List<String> jobsIdentifiers, List<String> executionStatuses, Secret token) {
        this.filterJobs = filterJobs != null ? filterJobs : false;
        this.jobsIdentifiers = jobsIdentifiers != null ? jobsIdentifiers : new ArrayList();
        this.executionStatuses = executionStatuses != null ? executionStatuses : Arrays.asList("SUCCEEDED");
        this.token = this.filterJobs != false ? null : token;
    }

    public void onNotification(ExecutionData execution) {
        if (this.job != null) {
            ((AbstractProject)this.job).scheduleBuild((Cause)new RundeckCause(execution));
        }
    }

    public RundeckTriggerCheckResult validateExecution(ExecutionData execution) {
        RundeckNotifier.RundeckDescriptor descriptor = new RundeckNotifier.RundeckDescriptor();
        RundeckInstance rundeckSelectedInstance = null;
        for (RundeckInstance rundeckInstance : descriptor.getRundeckInstances()) {
            if (execution.getHref() == null || !execution.getHref().toLowerCase().startsWith(rundeckInstance.getUrl().toLowerCase())) continue;
            rundeckSelectedInstance = rundeckInstance;
        }
        if (rundeckSelectedInstance != null) {
            return this.validateRundeckExecution(rundeckSelectedInstance, execution);
        }
        return new RundeckTriggerCheckResult("Rundeck instance not found", false);
    }

    private RundeckTriggerCheckResult validateRundeckExecution(RundeckInstance rundeckInstance, ExecutionData executionData) {
        RundeckClientManager rundeck = RundeckInstanceBuilder.createClient(rundeckInstance);
        try {
            Execution execution = rundeck.getExecution(executionData.getId());
            if (execution != null) {
                if (execution.getJob().getId().equals(executionData.getJob().getId()) && execution.getDateStarted().unixtime == executionData.getDateStarted().unixtime) {
                    return new RundeckTriggerCheckResult("OK", true);
                }
                return new RundeckTriggerCheckResult("Execution doesn't match with original values", false);
            }
        }
        catch (Exception e) {
            return new RundeckTriggerCheckResult(e.getMessage(), false);
        }
        return new RundeckTriggerCheckResult("execution not found", false);
    }

    public boolean shouldScheduleBuild(ExecutionData execution, String requestToken) throws UnsupportedEncodingException {
        if (!this.filterJobs.booleanValue()) {
            if (requestToken == null) {
                return false;
            }
            return this.token != null && MessageDigest.isEqual(this.token.getPlainText().getBytes(StandardCharsets.UTF_8), requestToken.getBytes(StandardCharsets.UTF_8));
        }
        if (!this.executionStatuses.contains(execution.getStatus().toUpperCase())) {
            return false;
        }
        for (String jobIdentifier : this.jobsIdentifiers) {
            if (!this.identifierMatchesJob(jobIdentifier, execution.getJob())) continue;
            return true;
        }
        return false;
    }

    private boolean identifierMatchesJob(String jobIdentifier, JobItem job) {
        String jobReference;
        if (job == null || StringUtils.isBlank((String)jobIdentifier)) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((String)job.getId(), (String)jobIdentifier)) {
            return true;
        }
        String fullname = job.getName();
        if (job.getGroup() != null) {
            fullname = job.getGroup() + "/" + job.getName();
        }
        return StringUtils.equalsIgnoreCase((String)(jobReference = job.getProject() + ":" + fullname), (String)jobIdentifier);
    }

    public Boolean isTokenConfigured() {
        if (this.token != null) {
            return true;
        }
        return false;
    }

    public String getRandomValue() {
        if (this.token == null) {
            UUID uuid = UUID.randomUUID();
            String uuidAsString = uuid.toString();
            return uuidAsString;
        }
        return this.token.getPlainText();
    }

    public Boolean getFilterJobs() {
        return this.filterJobs;
    }

    public List<String> getJobsIdentifiers() {
        return this.jobsIdentifiers;
    }

    public List<String> getExecutionStatuses() {
        return this.executionStatuses;
    }

    public Secret getToken() {
        return this.token;
    }

    public RundeckDescriptor getDescriptor() {
        return (RundeckDescriptor)super.getDescriptor();
    }

    static class RundeckTriggerCheckResult {
        String message;
        boolean valid;

        public RundeckTriggerCheckResult(String message, boolean result) {
            this.message = message;
            this.valid = result;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }
    }

    @Extension
    public static class RundeckDescriptor
    extends TriggerDescriptor {
        public RundeckDescriptor() {
            this.load();
        }

        public Trigger<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Secret tokenSecret = null;
            try {
                String token = formData.getJSONObject("filterJobs").getString("token");
                if (token != null) {
                    tokenSecret = Secret.fromString((String)formData.getJSONObject("filterJobs").getString("token"));
                }
            }
            catch (Exception e) {
                tokenSecret = null;
            }
            return new RundeckTrigger(formData.getJSONObject("filterJobs").getBoolean("value"), this.bindJSONToList(formData.getJSONObject("filterJobs").get("jobsIdentifiers")), this.bindJSONToList(formData.get("executionStatuses")), tokenSecret);
        }

        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return "Build when we receive a notification from Rundeck";
        }

        public String getDefaultRandomValue() {
            UUID uuid = UUID.randomUUID();
            String uuidAsString = uuid.toString();
            return uuidAsString;
        }

        private List<String> bindJSONToList(Object src) {
            ArrayList<String> result = new ArrayList<String>();
            if (src instanceof String) {
                result.add((String)src);
            } else if (src instanceof JSONObject) {
                result.add(((JSONObject)src).getString("value"));
            } else if (src instanceof JSONArray) {
                for (Object elem : (JSONArray)src) {
                    if (elem instanceof String) {
                        result.add((String)elem);
                        continue;
                    }
                    if (!(elem instanceof JSONObject)) continue;
                    result.add(((JSONObject)elem).getString("value"));
                }
            }
            return result;
        }
    }
}

