/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.RunDeckLogTail;
import org.jenkinsci.plugins.rundeck.RundeckInstance;
import org.jenkinsci.plugins.rundeck.RundeckInstanceBuilder;
import org.jenkinsci.plugins.rundeck.RundeckJobProjectLinkerAction;
import org.jenkinsci.plugins.rundeck.cache.DummyRundeckJobCache;
import org.jenkinsci.plugins.rundeck.cache.InMemoryRundeckJobCache;
import org.jenkinsci.plugins.rundeck.cache.RundeckJobCache;
import org.jenkinsci.plugins.rundeck.cache.RundeckJobCacheConfig;
import org.jenkinsci.plugins.rundeck.client.ExecutionData;
import org.jenkinsci.plugins.rundeck.client.RundeckClientManager;
import org.jenkinsci.plugins.rundeck.client.RundeckManager;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.rundeck.client.api.model.AbortResult;
import org.rundeck.client.api.model.ExecLog;
import org.rundeck.client.api.model.ExecOutput;
import org.rundeck.client.api.model.Execution;
import org.rundeck.client.api.model.JobItem;

public class RundeckNotifier
extends Notifier
implements SimpleBuildStep {
    private static final Logger log = Logger.getLogger(RundeckNotifier.class.getName());
    private static final transient Pattern TOKEN_ARTIFACT_NAME_PATTERN = Pattern.compile("\\$ARTIFACT_NAME\\{(.+)\\}");
    private static final transient Pattern JOB_REFERENCE_PATTERN = Pattern.compile("^([^:]+?):(.*?)\\/?([^/]+)$");
    private static final int DELAY_BETWEEN_POLLS_IN_MILLIS = 5000;
    private String rundeckInstance;
    private final String jobId;
    private final String options;
    private final String nodeFilters;
    @Deprecated
    private final transient String tag;
    @XStreamAlias(value="tags")
    private String[] tagsList;
    private final Boolean shouldWaitForRundeckJob;
    private final Boolean shouldFailTheBuild;
    private final Boolean notifyOnAllStatus;
    private final Boolean includeRundeckLogs;
    private final Boolean tailLog;
    private String jobUser;
    private Secret jobPassword;
    private Secret jobToken;
    private String performUser;

    RundeckNotifier(String rundeckInstance, String jobId, String options, String nodeFilters, String tags, Boolean shouldWaitForRundeckJob, Boolean shouldFailTheBuild, Boolean includeRundeckLogs, Boolean tailLog, String jobUser, Secret jobPassword, Secret jobToken) {
        this(rundeckInstance, jobId, options, nodeFilters, tags, shouldWaitForRundeckJob, shouldFailTheBuild, false, includeRundeckLogs, tailLog, jobUser, jobPassword, jobToken);
    }

    RundeckNotifier(String rundeckInstance, String jobId, String options, String nodeFilters, String tag, Boolean shouldWaitForRundeckJob, Boolean shouldFailTheBuild, String jobUser, Secret jobPassword, Secret jobToken) {
        this(rundeckInstance, jobId, options, nodeFilters, tag, shouldWaitForRundeckJob, shouldFailTheBuild, false, false, false, jobUser, jobPassword, jobToken);
    }

    @DataBoundConstructor
    public RundeckNotifier(String rundeckInstance, String jobId, String options, String nodeFilters, String tags, Boolean shouldWaitForRundeckJob, Boolean shouldFailTheBuild, Boolean notifyOnAllStatus, Boolean includeRundeckLogs, Boolean tailLog, String jobUser, Secret jobPassword, Secret jobToken) {
        this.rundeckInstance = rundeckInstance;
        this.jobId = jobId;
        this.options = options;
        this.nodeFilters = nodeFilters;
        this.tagsList = this.extracttags(tags, ",");
        this.tag = null;
        this.shouldWaitForRundeckJob = shouldWaitForRundeckJob;
        this.shouldFailTheBuild = shouldFailTheBuild;
        this.notifyOnAllStatus = notifyOnAllStatus;
        this.includeRundeckLogs = includeRundeckLogs;
        this.tailLog = tailLog;
        this.jobUser = jobUser;
        this.jobPassword = jobPassword;
        this.jobToken = jobToken;
    }

    public Object readResolve() {
        if (StringUtils.isEmpty((String)this.rundeckInstance)) {
            this.rundeckInstance = "Default";
        }
        if (this.tagsList == null) {
            this.tagsList = this.extracttags(this.tag, ",");
        }
        return this;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException {
        if (!Boolean.TRUE.equals(this.notifyOnAllStatus) && run.getResult() != Result.SUCCESS && run.getResult() != null) {
            return;
        }
        RundeckManager rundeckClientManager = this.getDescriptor().getRundeckJobInstance(this.rundeckInstance, this.jobUser, this.getPassword(), this.getToken());
        if (rundeckClientManager == null) {
            listener.getLogger().println("Rundeck configuration is not valid !");
            throw new AbortException("Rundeck configuration is not valid !");
        }
        this.performUser = rundeckClientManager.getRundeckInstance().getLogin();
        if (this.performUser == null && this.jobToken != null) {
            this.performUser = "Authenticate By token";
        }
        try {
            rundeckClientManager.ping();
        }
        catch (IOException e) {
            listener.getLogger().println("Rundeck is not running !");
            throw new AbortException("Rundeck is not running !");
        }
        if (this.shouldNotifyRundeck(run, listener)) {
            this.notifyRundeck(rundeckClientManager, run, listener);
        }
    }

    private ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet(@Nonnull Run<?, ?> run) {
        if (run instanceof AbstractBuild) {
            AbstractBuild b = (AbstractBuild)run;
            return b.getChangeSet();
        }
        return ChangeLogSet.createEmpty(run);
    }

    private boolean shouldNotifyRundeck(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) {
        String info = "Instance '" + this.getRundeckInstance() + "' with rundeck user '" + this.performUser + "': Notifying Rundeck...";
        if (this.tagsList.length == 0) {
            listener.getLogger().println(info);
            return true;
        }
        for (ChangeLogSet.Entry changeLog : this.getChangeSet(build)) {
            for (String tag : this.tagsList) {
                if (!StringUtils.containsIgnoreCase((String)changeLog.getMsg(), (String)tag)) continue;
                listener.getLogger().println("Found " + tag + " in changelog (from " + changeLog.getAuthor().getId() + ") - Notifying Rundeck...");
                return true;
            }
        }
        for (Cause cause : build.getCauses()) {
            AbstractProject upstreamProject;
            AbstractBuild upstreamBuild;
            if (!Cause.UpstreamCause.class.isInstance(cause)) continue;
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
            TopLevelItem item = Hudson.getInstance().getItem(upstreamCause.getUpstreamProject());
            if (!AbstractProject.class.isInstance(item) || (upstreamBuild = (upstreamProject = (AbstractProject)item).getBuildByNumber(upstreamCause.getUpstreamBuild())) == null) continue;
            for (ChangeLogSet.Entry changeLog : upstreamBuild.getChangeSet()) {
                for (String tag : this.tagsList) {
                    if (!StringUtils.containsIgnoreCase((String)changeLog.getMsg(), (String)tag)) continue;
                    listener.getLogger().println("Found " + tag + " in changelog (from " + changeLog.getAuthor().getId() + ") in upstream build (" + upstreamBuild.getFullDisplayName() + ") - Notifying Rundeck...");
                    return true;
                }
            }
        }
        return false;
    }

    private void notifyRundeck(RundeckManager rundeckClientManager, Run<?, ?> build, TaskListener listener) throws AbortException {
        String runtimeJobId;
        try {
            EnvVars env = build.getEnvironment(listener);
            runtimeJobId = env.expand(this.jobId);
            listener.getLogger().println("Looking for jobId : " + runtimeJobId);
        }
        catch (IOException | InterruptedException e) {
            listener.getLogger().println("Failed substituting environment in: " + this.jobId + " : " + e.getMessage());
            throw new AbortException("Failed substituting environment in: " + this.jobId + " : " + e.getMessage());
        }
        String foundJobId = null;
        try {
            foundJobId = RundeckDescriptor.findJobId(runtimeJobId, rundeckClientManager);
        }
        catch (IOException e) {
            listener.getLogger().println("Failed to get job with the identifier : " + runtimeJobId + " : " + e.getMessage());
            throw new AbortException("Failed to get job with the identifier : " + runtimeJobId + " : " + e.getMessage());
        }
        if (foundJobId == null) {
            listener.getLogger().println("Could not find a job with the identifier : " + runtimeJobId);
            throw new AbortException("Could not find a job with the identifier : " + runtimeJobId);
        }
        try {
            Properties optionProperties = this.parseProperties(this.options, build, listener);
            Properties nodeFiltersProperties = this.parseProperties(this.nodeFilters, build, listener);
            Execution execution = rundeckClientManager.runExecution(foundJobId, optionProperties, nodeFiltersProperties);
            listener.getLogger().printf("Notification succeeded ! Execution #%s, at %s (status : %s)%n", execution.getId(), execution.getPermalink(), execution.getStatus());
            build.addAction((Action)new RundeckExecutionBuildBadgeAction(execution.getPermalink()));
            if (Boolean.TRUE.equals(this.shouldWaitForRundeckJob)) {
                listener.getLogger().println("Waiting for Rundeck execution to finish...");
                if (Boolean.TRUE.equals(this.includeRundeckLogs) && Boolean.TRUE.equals(this.tailLog)) {
                    execution = this.waitTailingRundeckLogsAndReturnExecution(rundeckClientManager, listener, execution);
                } else {
                    execution = this.waitForRundeckExecutionToFinishAndReturnIt(rundeckClientManager, listener, execution);
                    if (Boolean.TRUE.equals(this.includeRundeckLogs)) {
                        this.getAndPrintRundeckLogsForExecution(rundeckClientManager, listener, execution.getId());
                    }
                }
                switch (execution.getStatus()) {
                    case "succeeded": {
                        return;
                    }
                    case "aborted": 
                    case "failed": 
                    case "running": {
                        if (this.getShouldFailTheBuild().booleanValue()) {
                            build.setResult(Result.FAILURE);
                        }
                        throw new AbortException();
                    }
                }
                throw new IllegalStateException(String.format("Unexpected executions status: %s", execution.getStatus()));
            }
            return;
        }
        catch (IOException e) {
            listener.getLogger().println("Error while talking to Rundeck's API at " + rundeckClientManager.getRundeckInstance().getUrl() + " : " + e.getMessage());
            throw new AbortException("Error while talking to Rundeck's API at " + rundeckClientManager.getRundeckInstance().getUrl() + " : " + e.getMessage());
        }
    }

    private Execution waitTailingRundeckLogsAndReturnExecution(RundeckManager rundeckClientManager, TaskListener listener, Execution execution) throws IOException {
        listener.getLogger().println("BEGIN RUNDECK TAILED LOG OUTPUT");
        RunDeckLogTail runDeckLogTail = new RunDeckLogTail(rundeckClientManager, Long.valueOf(execution.getId()));
        PrintStream printStream = listener.getLogger();
        for (List aRunDeckLogTail : runDeckLogTail) {
            for (ExecLog rundeckOutputEntry : aRunDeckLogTail) {
                printStream.println("[" + rundeckOutputEntry.node + "] [" + rundeckOutputEntry.time + "] [" + rundeckOutputEntry.level + "] " + rundeckOutputEntry.log);
            }
        }
        listener.getLogger().println("END RUNDECK TAILED LOG OUTPUT");
        execution = rundeckClientManager.getExecution(execution.getId());
        this.logExecutionStatus(listener, execution, "finished");
        return execution;
    }

    private void logExecutionStatus(TaskListener listener, Execution execution, String operationName) {
        ExecutionData executionData = new ExecutionData(execution);
        String duration = executionData.getDuration();
        listener.getLogger().printf("Rundeck execution #%s %s in %s, with status : %s%n", execution.getId(), operationName, duration, execution.getStatus());
    }

    private Properties parseProperties(String input, Run<?, ?> build, TaskListener listener) {
        if (StringUtils.isBlank((String)input)) {
            return new Properties();
        }
        try {
            EnvVars envVars = build.getEnvironment(listener);
            input = Util.replaceMacro((String)input, (Map)envVars);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed to expand environment variables : " + e.getMessage());
        }
        Matcher matcher = TOKEN_ARTIFACT_NAME_PATTERN.matcher(input);
        int idx = 0;
        block4: while (matcher.reset(input).find(idx)) {
            idx = matcher.end();
            String regex = matcher.group(1);
            Pattern pattern = Pattern.compile(regex);
            for (Run.Artifact artifact : build.getArtifacts()) {
                if (!pattern.matcher(artifact.getFileName()).matches()) continue;
                input = StringUtils.replace((String)input, (String)matcher.group(0), (String)artifact.getFileName());
                idx = matcher.start() + artifact.getFileName().length();
                continue block4;
            }
        }
        try {
            return Util.loadProperties((String)input);
        }
        catch (IOException e) {
            listener.getLogger().println("Failed to parse : " + input);
            listener.getLogger().println("Error : " + e.getMessage());
            return null;
        }
    }

    private Execution waitForRundeckExecutionToFinishAndReturnIt(RundeckManager rundeckClientManager, TaskListener listener, Execution execution) throws IOException {
        try {
            while (RundeckClientManager.ExecutionStatus.RUNNING.toString().equals(execution.getStatus())) {
                Thread.sleep(5000L);
                execution = rundeckClientManager.getExecution(execution.getId());
            }
            this.logExecutionStatus(listener, execution, "finished");
        }
        catch (IOException | InterruptedException e) {
            listener.getLogger().println("Waiting was interrupted. Probably build was cancelled. Reason: " + e);
            listener.getLogger().println("Trying to abort Rundeck execution...");
            AbortResult rundeckAbort = rundeckClientManager.abortExecution(execution.getId());
            listener.getLogger().printf("Abort status: %s%n", rundeckAbort.abort.status);
            execution = rundeckClientManager.getExecution(execution.getId());
            this.logExecutionStatus(listener, execution, "aborted");
        }
        return execution;
    }

    private void getAndPrintRundeckLogsForExecution(RundeckManager rundeckClientManager, TaskListener listener, String executionId) throws IOException {
        List logEntries;
        listener.getLogger().println("BEGIN RUNDECK LOG OUTPUT");
        ExecOutput rundeckOutput = rundeckClientManager.getOutput(executionId, (Long)0L, 0L, 0L);
        if (null != rundeckOutput && null != (logEntries = rundeckOutput.entries)) {
            for (ExecLog rundeckOutputEntry : logEntries) {
                listener.getLogger().println("[" + rundeckOutputEntry.node + "] [" + rundeckOutputEntry.time + "] [" + rundeckOutputEntry.level + "] " + rundeckOutputEntry.log);
            }
        }
        listener.getLogger().println("END RUNDECK LOG OUTPUT");
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        try {
            return new RundeckJobProjectLinkerAction(this.rundeckInstance, this.getDescriptor().getRundeckJobInstance(this.rundeckInstance, this.jobUser, this.getPassword(), this.getToken()), this.jobId);
        }
        catch (Exception e) {
            log.warning(String.format("Unable to create rundeck job project linked action for '%s'. Exception: %s: %s", project.getDisplayName(), e.getClass().getSimpleName(), e.getMessage()));
            return null;
        }
    }

    public boolean needsToRunAfterFinalized() {
        return this.shouldFailTheBuild == false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getRundeckInstance() {
        return this.rundeckInstance;
    }

    public String getJobIdentifier() {
        return this.jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getOptions() {
        return this.options;
    }

    public String getNodeFilters() {
        return this.nodeFilters;
    }

    public String getTag() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tagsList.length; ++i) {
            builder.append(this.tagsList[i]);
            if (i + 1 >= this.tagsList.length) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public String getTags() {
        return this.getTag();
    }

    public String[] getTagsList() {
        return Arrays.copyOf(this.tagsList, this.tagsList.length);
    }

    public Boolean getShouldWaitForRundeckJob() {
        return this.shouldWaitForRundeckJob;
    }

    public Boolean getShouldFailTheBuild() {
        return this.shouldFailTheBuild;
    }

    public Boolean getNotifyOnAllStatus() {
        return this.notifyOnAllStatus;
    }

    public Boolean getIncludeRundeckLogs() {
        return this.includeRundeckLogs;
    }

    public Boolean getTailLog() {
        return this.tailLog;
    }

    public String getJobUser() {
        return this.jobUser;
    }

    public Secret getJobPassword() {
        return this.jobPassword;
    }

    public Secret getJobToken() {
        return this.jobToken;
    }

    public String getPassword() {
        if (this.jobPassword != null) {
            return this.jobPassword.getPlainText();
        }
        return null;
    }

    public String getToken() {
        if (this.jobToken != null) {
            return this.jobToken.getPlainText();
        }
        return null;
    }

    public RundeckDescriptor getDescriptor() {
        return (RundeckDescriptor)super.getDescriptor();
    }

    private String[] extracttags(String tagsStr, String delimiter) {
        if (tagsStr == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(tagsStr.split(delimiter)));
        ListIterator<String> iterator = list.listIterator();
        while (iterator.hasNext()) {
            String tag = (String)iterator.next();
            tag = tag.replaceAll("\\s+", "").trim();
            iterator.remove();
            if (tag.equals("")) continue;
            iterator.add(tag);
        }
        return list.toArray(new String[list.size()]);
    }

    private static RundeckDescriptor getRundeckDescriptor() {
        return (RundeckDescriptor)((Object)Jenkins.getInstance().getExtensionList(RundeckDescriptor.class).get(0));
    }

    public static class RundeckExecutionBuildBadgeAction
    implements BuildBadgeAction {
        private final String executionUrl;

        public RundeckExecutionBuildBadgeAction(String executionUrl) {
            this.executionUrl = executionUrl;
        }

        public String getDisplayName() {
            return "Rundeck Execution Result";
        }

        public String getIconFileName() {
            return "/plugin/rundeck/images/rundeck_24x24.png";
        }

        public String getUrlName() {
            return this.executionUrl;
        }
    }

    @Extension(ordinal=1000.0)
    public static final class RundeckDescriptor
    extends BuildStepDescriptor<Publisher> {
        @Deprecated
        private transient RundeckInstance rundeckInstance;
        private volatile CopyOnWriteList<RundeckInstance> rundeckInstances = new CopyOnWriteList();
        private volatile transient RundeckJobCache rundeckJobCache = new DummyRundeckJobCache();
        private volatile RundeckJobCacheConfig rundeckJobCacheConfig = RundeckJobCacheConfig.initializeWithDefaultValues();
        private volatile transient RundeckInstanceBuilder rundeckBuilder = new RundeckInstanceBuilder();

        public RundeckDescriptor() {
            this.load();
        }

        public synchronized void load() {
            super.load();
            this.initializeRundeckJobCache();
        }

        public void setRundeckBuilder(RundeckInstanceBuilder rundeckBuilder) {
            this.rundeckBuilder = rundeckBuilder;
        }

        private void initializeRundeckJobCache() {
            if (this.rundeckJobCacheConfig.isEnabled()) {
                log.info("Rundeck job cache enabled. Using following configuration: " + this.rundeckJobCacheConfig);
                this.rundeckJobCache = new InMemoryRundeckJobCache(this.rundeckJobCacheConfig);
            } else {
                log.info("Rundeck job cache DISABLED.");
                this.rundeckJobCache.invalidate();
                this.rundeckJobCache = new DummyRundeckJobCache();
            }
        }

        protected Object readResolve() {
            if (this.rundeckInstance != null) {
                RundeckInstance instance = RundeckInstance.builder().client(this.rundeckInstance).build();
                instance.setName("Default");
                RundeckInstance[] rundeckArr = new RundeckInstance[]{instance};
                this.setRundeckInstances(rundeckArr);
            }
            return this;
        }

        protected XmlFile getConfigFile() {
            XStream2 xs = new XStream2();
            xs.addCompatibilityAlias("org.rundeck.api.RundeckClient", RundeckInstance.class);
            return new XmlFile((XStream)xs, new File(Jenkins.getActiveInstance().getRootDir(), this.getId() + ".xml"));
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            CopyOnWriteList newInstances = new CopyOnWriteList();
            newInstances.replaceBy((Collection)req.bindJSONToList(RundeckInstance.class, json.get("rundeckInstances")));
            this.setRundeckInstances((RundeckInstance[])newInstances.toArray((Object[])new RundeckInstance[0]));
            this.configureRundeckJobCache(json);
            this.save();
            return super.configure(req, json);
        }

        private void configureRundeckJobCache(JSONObject json) {
            boolean cacheEnabledAsBoolean = json.has("rundeckJobCacheEnabled");
            if (cacheEnabledAsBoolean == this.rundeckJobCacheConfig.isEnabled()) {
                return;
            }
            this.rundeckJobCacheConfig.setEnabled(cacheEnabledAsBoolean);
            this.initializeRundeckJobCache();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String rundeckInstance = formData.getString("rundeckInstance");
            String jobIdentifier = formData.getString("jobIdentifier");
            String jobUser = formData.getString("jobUser");
            String jobPassword = formData.getString("jobPassword");
            String jobToken = formData.getString("jobToken");
            if (!jobIdentifier.contains("$")) {
                JobItem job = null;
                try {
                    Secret password = Secret.fromString((String)jobPassword);
                    Secret token = Secret.fromString((String)jobToken);
                    job = RundeckDescriptor.findJobUncached(jobIdentifier, this.getRundeckJobInstance(rundeckInstance, jobUser, Util.fixEmpty((String)password.getPlainText()), Util.fixEmpty((String)token.getPlainText())));
                }
                catch (Exception e) {
                    throw new Descriptor.FormException("Failed to get job with the identifier : " + jobIdentifier, (Throwable)e, "jobIdentifier");
                }
                if (job == null) {
                    throw new Descriptor.FormException("Could not find a job with the identifier : " + jobIdentifier, "jobIdentifier");
                }
            }
            return new RundeckNotifier(rundeckInstance, jobIdentifier, formData.getString("options"), formData.getString("nodeFilters"), formData.getString("tag"), formData.getBoolean("shouldWaitForRundeckJob"), formData.getBoolean("shouldFailTheBuild"), formData.getBoolean("notifyOnAllStatus"), formData.getBoolean("includeRundeckLogs"), formData.getBoolean("tailLog"), jobUser, Secret.fromString((String)jobPassword), Secret.fromString((String)jobToken));
        }

        @RequirePOST
        public FormValidation doDisplayCacheStatistics() {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.ok((String)this.rundeckJobCache.logAndGetStats());
        }

        @RequirePOST
        public FormValidation doInvalidateCache() {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            this.rundeckJobCache.invalidate();
            return FormValidation.ok((String)"Done");
        }

        @RequirePOST
        public FormValidation doCheckJobIdentifier(@QueryParameter(value="jobIdentifier") String jobIdentifier, @QueryParameter(value="rundeckInstance") String rundeckInstance, @QueryParameter(value="jobUser") String user, @QueryParameter(value="jobPassword") Secret password, @QueryParameter(value="jobToken") Secret token, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if (password == null && !StringUtils.isBlank((String)user)) {
                return FormValidation.error((String)"The password is mandatory if user is not empty !");
            }
            if (rundeckInstance == null) {
                return FormValidation.error((String)"There are no rundeck instances configured. !");
            }
            RundeckManager client = null;
            try {
                client = this.getRundeckJobInstance(rundeckInstance, user, Util.fixEmpty((String)password.getPlainText()), Util.fixEmpty((String)token.getPlainText()));
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
            if (client == null) {
                return FormValidation.error((String)"Rundeck global configuration is not valid !");
            }
            if (StringUtils.isBlank((String)jobIdentifier)) {
                return FormValidation.error((String)"The job identifier is mandatory !");
            }
            String userLogin = client.getRundeckInstance().getLogin();
            if (userLogin == null) {
                userLogin = "Authenticate by Token";
            }
            try {
                if (jobIdentifier.contains("$")) {
                    return FormValidation.warning((String)"Unable to substitute environment at configuration time. The build will fail if the job does not exist");
                }
                JobItem job = RundeckDescriptor.findJobUncached(jobIdentifier, client);
                if (job == null) {
                    return FormValidation.error((String)"Could not find a job with the identifier : %s", (Object[])new Object[]{jobIdentifier});
                }
                String fullname = job.getName();
                if (job.getGroup() != null && !job.getGroup().isEmpty()) {
                    fullname = job.getGroup() + "/" + job.getName();
                }
                return FormValidation.ok((String)"Your Rundeck job is : [user:%s]  %s [%s] %s", (Object[])new Object[]{userLogin, job.getId(), job.getProject(), fullname});
            }
            catch (Exception e) {
                return FormValidation.error((String)"Failed to get job details : %s", (Object[])new Object[]{e.getMessage()});
            }
        }

        static String findJobId(String jobIdentifier, RundeckManager rundeckClient) throws IOException, IllegalArgumentException {
            log.fine(String.format("findJobId request for jobId: %s", jobIdentifier));
            Matcher matcher = JOB_REFERENCE_PATTERN.matcher(jobIdentifier);
            if (matcher.find() && matcher.groupCount() == 3) {
                String project = matcher.group(1);
                String groupPath = matcher.group(2);
                String name = matcher.group(3);
                return rundeckClient.findJobId(project, name, groupPath);
            }
            return jobIdentifier;
        }

        public static JobItem findJob(String jobIdentifier, String rundeckInstanceName, RundeckManager rundeckInstance) {
            RundeckJobCache rundeckJobCache = RundeckNotifier.getRundeckDescriptor().rundeckJobCache;
            return rundeckJobCache.findJobById(jobIdentifier, rundeckInstanceName, rundeckInstance);
        }

        public static JobItem findJobUncached(String jobIdentifier, RundeckManager rundeckClient) {
            RundeckJobCacheConfig rundeckJobCacheConfig = RundeckNotifier.getRundeckDescriptor().getRundeckJobCacheConfig();
            if (rundeckJobCacheConfig.isEnabled()) {
                log.info(String.format("NOT CACHED findJobUncached request for jobId: %s", jobIdentifier));
            } else {
                log.fine(String.format("findJobUncached request for jobId: %s (cache disabled)", jobIdentifier));
            }
            JobItem job = null;
            Matcher matcher = JOB_REFERENCE_PATTERN.matcher(jobIdentifier);
            if (matcher.find() && matcher.groupCount() == 3) {
                String project = matcher.group(1);
                String groupPath = matcher.group(2);
                String name = matcher.group(3);
                try {
                    job = rundeckClient.findJob(project, groupPath, name);
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
            } else {
                try {
                    job = rundeckClient.getJob(jobIdentifier);
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                }
            }
            return job;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Rundeck";
        }

        public RundeckInstance getRundeckInstance(String name) {
            for (RundeckInstance eachInstance : this.rundeckInstances) {
                if (!eachInstance.getName().equals(name)) continue;
                return eachInstance;
            }
            return null;
        }

        public RundeckManager getRundeckJobInstance(String rundeckInstanceName, String jobUser, String jobPassword, String jobToken) {
            String url;
            RundeckInstance newInstance;
            RundeckInstance instance = null;
            for (RundeckInstance eachInstance : this.rundeckInstances) {
                if (!eachInstance.getName().equals(rundeckInstanceName)) continue;
                instance = eachInstance;
            }
            if (instance == null) {
                return null;
            }
            if (this.rundeckBuilder == null) {
                this.rundeckBuilder = new RundeckInstanceBuilder();
            }
            RundeckManager client = this.rundeckBuilder.getClient() == null ? RundeckInstanceBuilder.createClient(instance) : this.rundeckBuilder.getClient();
            int apiVersion = RundeckClientManager.API_VERSION;
            if (instance.getApiVersion() != null) {
                apiVersion = instance.getApiVersion();
            }
            if (client != null && jobUser != null && !jobUser.isEmpty() && !jobUser.equals(client.getRundeckInstance().getLogin())) {
                newInstance = new RundeckInstance();
                url = client.getRundeckInstance().getUrl();
                newInstance.setUrl(url);
                newInstance.setLogin(jobUser);
                newInstance.setPassword(Secret.fromString((String)jobPassword));
                newInstance.setApiVersion(apiVersion);
                client = new RundeckClientManager(newInstance);
            }
            if (client != null && jobToken != null && !jobToken.isEmpty()) {
                newInstance = new RundeckInstance();
                url = client.getRundeckInstance().getUrl();
                newInstance.setUrl(url);
                newInstance.setToken(Secret.fromString((String)jobToken));
                newInstance.setApiVersion(apiVersion);
                client = new RundeckClientManager(newInstance);
            }
            return client;
        }

        public void addRundeckInstance(RundeckInstance instance) {
            this.rundeckInstances.add((Object)instance);
        }

        public RundeckInstance[] getRundeckInstances() {
            return (RundeckInstance[])this.rundeckInstances.toArray((Object[])new RundeckInstance[0]);
        }

        public void setRundeckInstances(RundeckInstance[] instances) {
            this.rundeckInstances.replaceBy((Object[])instances);
        }

        public RundeckJobCacheConfig getRundeckJobCacheConfig() {
            return this.rundeckJobCacheConfig;
        }
    }
}

