/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.model.Action;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.RundeckNotifier;
import org.jenkinsci.plugins.rundeck.client.RundeckManager;
import org.kohsuke.stapler.export.Exported;
import org.rundeck.client.api.model.JobItem;

public class RundeckJobProjectLinkerAction
implements Action {
    private final String rundeckInstanceName;
    private final RundeckManager rundeck;
    private final JobItem rundeckJob;
    private final String rundeckJobUrl;

    public RundeckJobProjectLinkerAction(String rundeckInstanceName, RundeckManager rundeck, String rundeckJobId) throws Exception, IllegalArgumentException {
        if (rundeck == null) {
            throw new IllegalArgumentException("rundeckClient should not be null !");
        }
        this.rundeckInstanceName = rundeckInstanceName;
        this.rundeck = rundeck;
        this.rundeckJob = RundeckNotifier.RundeckDescriptor.findJob(rundeckJobId, rundeckInstanceName, rundeck);
        this.rundeckJobUrl = this.buildRundeckJobUrl();
    }

    private String buildRundeckJobUrl() {
        StringBuilder url = new StringBuilder();
        url.append(this.rundeck.getRundeckInstance().getUrl());
        if (!StringUtils.endsWith((String)this.rundeck.getRundeckInstance().getUrl(), (String)"/")) {
            url.append("/");
        }
        url.append("job/show/");
        url.append(this.rundeckJob.getId());
        return url.toString();
    }

    @Exported
    public JobItem getRundeckJob() {
        return this.rundeckJob;
    }

    public String getIconFileName() {
        return "/plugin/rundeck/images/rundeck_24x24.png";
    }

    public String getDisplayName() {
        return "Job: [" + this.rundeckJob.getProject() + "] " + this.rundeckJob.getName();
    }

    public String getUrlName() {
        return this.rundeckJobUrl;
    }

    public String getInstanceName() {
        return this.rundeckInstanceName;
    }
}

