/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.rundeck.RundeckInstanceBuilder;
import org.jenkinsci.plugins.rundeck.client.RundeckClientManager;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.rundeck.client.api.LoginFailed;

public class RundeckInstance
extends AbstractDescribableImpl<RundeckInstance> {
    private String name;
    private String url;
    private Integer apiVersion = RundeckClientManager.API_VERSION;
    private String login;
    private Secret token;
    private Secret password;
    private boolean sslHostnameVerifyAllowAll;
    private boolean sslCertificateTrustAllowSelfSigned;
    private boolean systemProxyEnabled;
    private boolean useIntermediateStreamFile;

    @DataBoundConstructor
    public RundeckInstance(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public RundeckInstance() {
    }

    public static RundeckInstanceBuilder builder() {
        return new RundeckInstanceBuilder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getApiVersion() {
        return this.apiVersion;
    }

    @DataBoundSetter
    public void setApiVersion(int apiVersion) {
        if (apiVersion > 0) {
            this.apiVersion = apiVersion;
        }
    }

    public String getLogin() {
        return this.login;
    }

    @DataBoundSetter
    public void setLogin(String login) {
        this.login = login;
    }

    public Secret getToken() {
        return this.token;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getTokenPlainText() {
        if (this.token != null) {
            return this.token.getPlainText();
        }
        return null;
    }

    @DataBoundSetter
    public void setToken(Secret token) {
        this.token = token;
    }

    public String getPasswordPlainText() {
        if (this.password != null) {
            return this.password.getPlainText();
        }
        return null;
    }

    @DataBoundSetter
    public void setPassword(Secret password) {
        this.password = password;
    }

    public boolean isSslHostnameVerifyAllowAll() {
        return this.sslHostnameVerifyAllowAll;
    }

    public void setSslHostnameVerifyAllowAll(boolean sslHostnameVerifyAllowAll) {
        this.sslHostnameVerifyAllowAll = sslHostnameVerifyAllowAll;
    }

    public boolean isSslCertificateTrustAllowSelfSigned() {
        return this.sslCertificateTrustAllowSelfSigned;
    }

    public void setSslCertificateTrustAllowSelfSigned(boolean sslCertificateTrustAllowSelfSigned) {
        this.sslCertificateTrustAllowSelfSigned = sslCertificateTrustAllowSelfSigned;
    }

    public boolean isSystemProxyEnabled() {
        return this.systemProxyEnabled;
    }

    public void setSystemProxyEnabled(boolean systemProxyEnabled) {
        this.systemProxyEnabled = systemProxyEnabled;
    }

    public boolean isUseIntermediateStreamFile() {
        return this.useIntermediateStreamFile;
    }

    public void setUseIntermediateStreamFile(boolean useIntermediateStreamFile) {
        this.useIntermediateStreamFile = useIntermediateStreamFile;
    }

    public String toString() {
        return "RundeckInstance{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", apiVersion=" + this.apiVersion + ", login='" + this.login + '\'' + ", token=" + this.token + ", sslHostnameVerifyAllowAll=" + this.sslHostnameVerifyAllowAll + ", sslCertificateTrustAllowSelfSigned=" + this.sslCertificateTrustAllowSelfSigned + ", systemProxyEnabled=" + this.systemProxyEnabled + ", useIntermediateStreamFile=" + this.useIntermediateStreamFile + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RundeckInstance> {
        public String getDisplayName() {
            return "";
        }

        @RequirePOST
        public FormValidation doTestConnection(@QueryParameter(value="url") String url, @QueryParameter(value="login") String login, @QueryParameter(value="password") Secret password, @QueryParameter(value="token") Secret token, @QueryParameter(value="apiVersion", fixEmpty=true) Integer apiVersion) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            RundeckInstanceBuilder builder = new RundeckInstanceBuilder().url(url);
            if (null != apiVersion && apiVersion > 0) {
                builder.version(apiVersion);
            } else {
                builder.version(RundeckClientManager.API_VERSION);
            }
            try {
                if (!token.getPlainText().isEmpty()) {
                    builder.token(token);
                } else {
                    builder.login(login, password);
                }
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)"Rundeck configuration is not valid ! %s", (Object[])new Object[]{e.getMessage()});
            }
            RundeckInstance instance = builder.build();
            RundeckClientManager rundeck = RundeckInstanceBuilder.createClient(instance);
            try {
                rundeck.ping();
            }
            catch (LoginFailed e) {
                return FormValidation.error((String)"Error: %s", (Object[])new Object[]{e.getMessage()});
            }
            catch (Exception e) {
                return FormValidation.error((String)"We couldn't find a live Rundeck instance at %s error: %s", (Object[])new Object[]{rundeck.getRundeckInstance().getUrl(), e.getMessage()});
            }
            try {
                rundeck.testAuth();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Error: " + e.getMessage() + " authenticating Rundeck !"), (Object[])new Object[]{rundeck.getRundeckInstance().getUrl()});
            }
            return FormValidation.ok((String)"Your Rundeck instance is alive, and your credentials are valid !");
        }
    }
}

