/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.EnvironmentContributingAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.client.ExecutionData;
import org.rundeck.client.api.model.Execution;

public class RundeckCause
extends Cause {
    private static final Pattern ARG_STRING_PATTERN = Pattern.compile("(\\S+)\\s\"?(.+)");
    private final transient Execution execution;

    public RundeckCause(Execution execution) {
        this.execution = execution;
    }

    public String getShortDescription() {
        StringBuilder description = new StringBuilder();
        if (this.execution != null) {
            description.append("Started by <a href=\"");
            description.append(this.execution.getPermalink());
            description.append("\">Rundeck Execution #");
            description.append(this.execution.getId());
            description.append("</a>");
            if (this.execution.getJob() != null) {
                String fullname = this.execution.getJob().getName();
                if (this.execution.getJob().getGroup() != null) {
                    fullname = this.execution.getJob().getGroup() + "/" + this.execution.getJob().getName();
                }
                description.append(" [");
                description.append(this.execution.getJob().getProject());
                description.append("] ");
                description.append(fullname);
            }
        } else {
            description.append("Started by a Rundeck Notification");
        }
        return description.toString();
    }

    public void onAddedTo(AbstractBuild build) {
        super.onAddedTo(build);
        build.addAction((Action)new RundeckExecutionEnvironmentContributingAction(this.execution));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.execution == null ? 0 : this.execution.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RundeckCause other = (RundeckCause)((Object)obj);
        return !(this.execution == null ? other.execution != null : !this.execution.equals(other.execution));
    }

    public String toString() {
        return "RundeckCause [execution=" + this.execution + "]";
    }

    public static class RundeckExecutionEnvironmentContributingAction
    implements EnvironmentContributingAction {
        private final transient Execution execution;

        public RundeckExecutionEnvironmentContributingAction(Execution execution) {
            this.execution = execution;
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            ExecutionData executionData = new ExecutionData(this.execution);
            if (this.execution != null) {
                if (this.execution.getJob() != null) {
                    env.put("RDECK_JOB_ID", String.valueOf(this.execution.getJob().getId()));
                    env.put("RDECK_JOB_NAME", String.valueOf(this.execution.getJob().getName()));
                    env.put("RDECK_JOB_GROUP", String.valueOf(this.execution.getJob().getGroup()));
                    env.put("RDECK_JOB_DESCRIPTION", String.valueOf(this.execution.getJob().getDescription()));
                    env.put("RDECK_PROJECT", String.valueOf(this.execution.getJob().getProject()));
                }
                env.put("RDECK_EXEC_ID", String.valueOf(this.execution.getId()));
                env.put("RDECK_EXEC_STATUS", String.valueOf(this.execution.getStatus()));
                env.put("RDECK_EXEC_STARTED_BY", String.valueOf(this.execution.getUser()));
                env.put("RDECK_EXEC_STARTED_AT", String.valueOf(this.execution.getDateStarted().date));
                if (this.execution.getDateEnded() != null) {
                    env.put("RDECK_EXEC_ENDED_AT", String.valueOf(this.execution.getDateEnded().date));
                }
                env.put("RDECK_EXEC_ABORTED_BY", String.valueOf(this.execution.getUser()));
                env.put("RDECK_EXEC_DURATION_MILLIS", String.valueOf(executionData.getDurationInMillis()));
                env.put("RDECK_EXEC_DURATION_SECONDS", String.valueOf(executionData.getDurationInSeconds()));
                env.put("RDECK_EXEC_DURATION", String.valueOf(executionData.getDuration()));
                env.put("RDECK_EXEC_SHORT_DURATION", String.valueOf(executionData.getShortDuration()));
                env.put("RDECK_EXEC_URL", String.valueOf(this.execution.getHref()));
                env.put("RDECK_EXEC_DESCRIPTION", String.valueOf(this.execution.getDescription()));
                if (StringUtils.isNotEmpty((String)this.execution.getArgstring())) {
                    String[] args = this.execution.getArgstring().split("^-|\\s-");
                    for (int i = 1; i < args.length; ++i) {
                        Matcher matcher = ARG_STRING_PATTERN.matcher(args[i]);
                        if (!matcher.matches()) continue;
                        String key = matcher.group(1);
                        String value = StringUtils.trim((String)matcher.group(2));
                        if (value.endsWith("\"")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        env.put("RDECK_EXEC_ARG_" + key, value);
                    }
                }
            }
        }

        public String getDisplayName() {
            return this.execution != null ? "Started by Rundeck Execution #" + this.execution.getId() : null;
        }

        public String getIconFileName() {
            return this.execution != null ? "/plugin/rundeck/images/rundeck_24x24.png" : null;
        }

        public String getUrlName() {
            return this.execution != null ? this.execution.getPermalink() : null;
        }
    }
}

