/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.Functions;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.util.RunList;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class OptionProvider {
    public void doArtifact(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> build;
        Job<?, ?> project = this.findProject(request.getParameter("project"));
        if (project == null) {
            response.sendError(400, "You must provide a valid 'project' parameter !");
            return;
        }
        String artifactRegex = request.getParameter("artifactRegex");
        Pattern artifactPattern = null;
        if (StringUtils.isNotBlank((String)artifactRegex)) {
            try {
                artifactPattern = Pattern.compile(artifactRegex);
            }
            catch (PatternSyntaxException e) {
                response.sendError(400, "Invalid java-regex syntax for the 'artifactRegex' parameter : " + e.getMessage());
                return;
            }
        }
        if ((build = this.findBuild(request.getParameter("build"), project)) == null) {
            return;
        }
        try {
            this.checkArtifactPermissions(build);
        }
        catch (Exception e) {
            response.sendError(400, e.getMessage());
            return;
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (Run.Artifact artifact : build.getArtifacts()) {
            if (artifactPattern != null && !artifactPattern.matcher(artifact.getFileName()).matches()) continue;
            options.add(new Option(artifact.getFileName(), this.buildArtifactUrl(build, artifact)));
        }
        this.writeJson(options, response);
    }

    private String getItemTree(Item item, StringBuffer sb) {
        if (item == null) {
            List topItems = Hudson.getInstance().getItems();
            for (TopLevelItem topItem : topItems) {
                this.getItemTree((Item)topItem, sb);
            }
        } else if (item instanceof ItemGroup) {
            ItemGroup groupItem = (ItemGroup)item;
            for (Object anItem : groupItem.getItems()) {
                if (!(anItem instanceof Item)) continue;
                Item subItem = (Item)anItem;
                this.getItemTree(subItem, sb);
            }
        } else {
            sb.append(item.getFullName());
            sb.append("\n");
        }
        return sb.toString().replaceAll("%2F", "%252F");
    }

    public void doBuild(StaplerRequest request, StaplerResponse response) throws IOException {
        Run.Artifact artifact;
        Run build;
        Integer limit;
        Job<?, ?> project = this.findProject(request.getParameter("project"));
        if (project == null) {
            StringBuffer sb = new StringBuffer();
            String itemTree = this.getItemTree(null, sb);
            response.sendError(400, "You must provide a valid 'project' parameter !\n\n" + itemTree);
            return;
        }
        String artifactName = request.getParameter("artifact");
        String artifactRegex = request.getParameter("artifactRegex");
        if (StringUtils.isBlank((String)artifactName) && StringUtils.isBlank((String)artifactRegex)) {
            response.sendError(400, "You must provide either a valid 'artifact' or 'artifactRegex' parameter !");
            return;
        }
        Pattern artifactPattern = null;
        if (StringUtils.isNotBlank((String)artifactRegex)) {
            try {
                artifactPattern = Pattern.compile(artifactRegex);
            }
            catch (PatternSyntaxException e) {
                response.sendError(400, "Invalid java-regex syntax for the 'artifactRegex' parameter : " + e.getMessage());
                return;
            }
        }
        try {
            limit = Integer.parseInt(request.getParameter("limit"));
        }
        catch (NumberFormatException e) {
            limit = null;
        }
        ArrayList<Option> options = new ArrayList<Option>();
        RunList builds = project.getBuilds();
        for (Run build2 : builds) {
            Run.Artifact artifact2 = this.findArtifact(artifactName, artifactPattern, build2);
            if (artifact2 != null) {
                String buildName = build2.getDisplayName();
                options.add(new Option(buildName, this.buildArtifactUrl(build2, artifact2)));
            }
            if (limit == null || options.size() < limit) continue;
            break;
        }
        if (Boolean.valueOf(request.getParameter("includeLastStableBuild")).booleanValue()) {
            build = project.getLastStableBuild();
            artifact = this.findArtifact(artifactName, artifactPattern, build);
            if (build != null && artifact != null) {
                options.add(0, new Option("lastStableBuild", this.buildArtifactUrl(build, artifact)));
            }
        }
        if (Boolean.valueOf(request.getParameter("includeLastSuccessfulBuild")).booleanValue()) {
            build = project.getLastSuccessfulBuild();
            artifact = this.findArtifact(artifactName, artifactPattern, build);
            if (build != null && artifact != null) {
                options.add(0, new Option("lastSuccessfulBuild", this.buildArtifactUrl(build, artifact)));
            }
        }
        if (Boolean.valueOf(request.getParameter("includeLastBuild")).booleanValue()) {
            build = project.getLastBuild();
            artifact = this.findArtifact(artifactName, artifactPattern, build);
            if (build != null && artifact != null) {
                options.add(0, new Option("lastBuild", this.buildArtifactUrl(build, artifact)));
            }
        }
        this.writeJson(options, response);
    }

    private Job<?, ?> findProject(String projectName) {
        if (StringUtils.isBlank((String)projectName)) {
            return null;
        }
        return (Job)Hudson.getInstance().getItemByFullName(projectName, Job.class);
    }

    private Run<?, ?> findBuild(String buildNumber, Job<?, ?> project) {
        Run build;
        try {
            Integer buildNb = Integer.parseInt(buildNumber);
            Run build2 = project.getBuildByNumber(buildNb.intValue());
            if (build2 != null) {
                return build2;
            }
        }
        catch (NumberFormatException buildNb) {
            // empty catch block
        }
        if (StringUtils.equalsIgnoreCase((String)"lastStable", (String)buildNumber) ? (build = project.getLastStableBuild()) != null : StringUtils.equalsIgnoreCase((String)"lastSuccessful", (String)buildNumber) && (build = project.getLastSuccessfulBuild()) != null) {
            return build;
        }
        return project.getLastBuild();
    }

    private Run.Artifact findArtifact(String artifactName, Pattern artifactPattern, Run<?, ?> build) {
        if (build == null) {
            return null;
        }
        try {
            this.checkArtifactPermissions(build);
        }
        catch (Exception e) {
            return null;
        }
        for (Run.Artifact artifact : build.getArtifacts()) {
            if (StringUtils.equals((String)artifactName, (String)artifact.getFileName())) {
                return artifact;
            }
            if (artifactPattern == null || !artifactPattern.matcher(artifact.getFileName()).matches()) continue;
            return artifact;
        }
        return null;
    }

    private String buildArtifactUrl(Run<?, ?> build, Run.Artifact artifact) {
        StringBuilder url = new StringBuilder();
        url.append(Hudson.getInstance().getRootUrl());
        url.append(build.getUrl()).append("artifact/").append(artifact.getHref());
        return url.toString();
    }

    private void writeJson(List<Option> options, StaplerResponse response) throws IOException {
        JSONArray array = new JSONArray();
        array.addAll(options);
        String json = array.toString();
        response.setContentType("application/json;charset=UTF-8");
        response.getWriter().append(json);
    }

    private void checkArtifactPermissions(Run<?, ?> build) {
        if (Functions.isArtifactsPermissionEnabled()) {
            build.checkPermission(Run.ARTIFACTS);
        }
    }

    public static class Option
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String value;

        public Option(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Option other = (Option)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "Option [name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

