/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.IMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.model.ProjectNamingStrategy;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jenkinsci.plugins.rolestrategy.RoleBasedProjectNamingStrategy;
import org.jenkinsci.plugins.rolestrategy.Settings;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class RoleMap {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean FORCE_CASE_SENSITIVE = Boolean.getBoolean(RoleMap.class.getName() + ".FORCE_CASE_SENSITIVE");
    private final SortedMap<Role, Set<PermissionEntry>> grantedRoles;
    private static final Logger LOGGER = Logger.getLogger(RoleMap.class.getName());
    private static final Cache<Permission, Set<Permission>> implyingPermissionCache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(20L, TimeUnit.SECONDS).build();
    private final Cache<String, UserDetails> cache = Caffeine.newBuilder().maximumSize((long)Settings.USER_DETAILS_CACHE_MAX_SIZE).expireAfterWrite((long)Settings.USER_DETAILS_CACHE_EXPIRATION_TIME_SEC, TimeUnit.SECONDS).build();
    private final Cache<String, RoleMap> matchingRoleMapCache = Caffeine.newBuilder().maximumSize(2048L).expireAfterWrite(1L, TimeUnit.HOURS).build();

    RoleMap() {
        this.grantedRoles = new ConcurrentSkipListMap<Role, Set<PermissionEntry>>();
    }

    @DataBoundConstructor
    public RoleMap(@NonNull SortedMap<Role, Set<PermissionEntry>> grantedRoles) {
        this();
        for (Map.Entry<Role, Set<PermissionEntry>> entry : grantedRoles.entrySet()) {
            this.grantedRoles.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasPermission(final PermissionEntry sid, final Permission permission, final RoleType roleType, final AccessControlled controlledItem) {
        final Set<Permission> permissions = RoleMap.getImplyingPermissions(permission);
        final boolean[] hasPermission = new boolean[]{false};
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        final boolean principal = sid.getType() == AuthorizationType.USER;
        final IdStrategy strategy = principal ? securityRealm.getUserIdStrategy() : securityRealm.getGroupIdStrategy();
        new RoleWalker(){

            @CheckForNull
            private PermissionEntry hasPermission(Role current, PermissionEntry entry) {
                Set entries = (Set)RoleMap.this.grantedRoles.get(current);
                if (entries.contains(entry)) {
                    return entry;
                }
                PermissionEntry eitherEntry = new PermissionEntry(AuthorizationType.EITHER, entry.getSid());
                if (entries.contains(eitherEntry)) {
                    return eitherEntry;
                }
                if (!FORCE_CASE_SENSITIVE) {
                    for (PermissionEntry pe : entries) {
                        if (!pe.isApplicable(principal) || !strategy.equals(pe.getSid(), entry.getSid())) continue;
                        return pe;
                    }
                }
                return null;
            }

            @Override
            public void perform(Role current) {
                if (current.hasAnyPermission(permissions).booleanValue()) {
                    PermissionEntry entry = this.hasPermission(current, sid);
                    if (entry != null) {
                        if (Macro.isMacro(current)) {
                            RoleMacroExtension macroExtension;
                            Macro macro = RoleMacroExtension.getMacro(current.getName());
                            if (controlledItem != null && macro != null && (macroExtension = RoleMacroExtension.getMacroExtension(macro.getName())).IsApplicable(roleType)) {
                                if (Util.isOverridden(IMacroExtension.class, macroExtension.getClass(), (String)"hasPermission", (Class[])new Class[]{PermissionEntry.class, Permission.class, RoleType.class, AccessControlled.class, Macro.class})) {
                                    if (macroExtension.hasPermission(entry, permission, roleType, controlledItem, macro)) {
                                        hasPermission[0] = true;
                                        this.abort();
                                    }
                                } else if (macroExtension.hasPermission(entry.getSid(), permission, roleType, controlledItem, macro)) {
                                    hasPermission[0] = true;
                                    this.abort();
                                }
                            }
                        } else {
                            hasPermission[0] = true;
                            this.abort();
                        }
                    } else if (Settings.TREAT_USER_AUTHORITIES_AS_ROLES && sid.getType() == AuthorizationType.USER) {
                        try {
                            UserDetails userDetails = (UserDetails)RoleMap.this.cache.getIfPresent((Object)sid.getSid());
                            if (userDetails == null) {
                                userDetails = Jenkins.get().getSecurityRealm().loadUserByUsername2(sid.getSid());
                                RoleMap.this.cache.put((Object)sid.getSid(), (Object)userDetails);
                            }
                            for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
                                if (!grantedAuthority.getAuthority().equals(current.getName())) continue;
                                hasPermission[0] = true;
                                this.abort();
                                return;
                            }
                        }
                        catch (RuntimeException ex) {
                            LOGGER.log(Level.WARNING, "Unhandled exception during user authorities processing", ex);
                        }
                    }
                }
            }
        };
        return hasPermission[0];
    }

    private static Set<Permission> getImplyingPermissions(Permission p) {
        return (Set)implyingPermissionCache.get((Object)p, RoleMap::cacheImplyingPermissions);
    }

    private static Set<Permission> cacheImplyingPermissions(Permission permission) {
        Set<Permission> implyingPermissions;
        if (PermissionHelper.isDangerous(permission)) {
            implyingPermissions = RoleMap.getImplyingPermissions(Jenkins.ADMINISTER);
        } else {
            implyingPermissions = new HashSet<Permission>();
            Permission p = permission;
            while (p != null) {
                if (p.getEnabled()) {
                    implyingPermissions.add(p);
                }
                p = p.impliedBy;
            }
        }
        return implyingPermissions;
    }

    public boolean hasRole(@NonNull Role role) {
        return this.grantedRoles.containsKey(role);
    }

    public SidACL getACL(RoleType roleType, AccessControlled controlledItem) {
        return new AclImpl(roleType, controlledItem);
    }

    public void addRole(Role role) {
        if (this.getRole(role.getName()) == null) {
            this.grantedRoles.put(role, new CopyOnWriteArraySet());
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void addRole(Role role, Set<PermissionEntry> sids) {
        this.grantedRoles.put(role, new CopyOnWriteArraySet<PermissionEntry>(sids));
        this.matchingRoleMapCache.invalidateAll();
    }

    public void assignRole(Role role, PermissionEntry sid) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).add(sid);
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    @Deprecated
    public void assignRole(Role role, String sid) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).add(new PermissionEntry(AuthorizationType.EITHER, sid));
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void unAssignRole(Role role, PermissionEntry sid) {
        Set sids = (Set)this.grantedRoles.get(role);
        if (sids != null) {
            sids.remove(sid);
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    @Deprecated
    public void unAssignRole(Role role, String sid) {
        Set sids = (Set)this.grantedRoles.get(role);
        if (sids != null) {
            sids.remove(new PermissionEntry(AuthorizationType.EITHER, sid));
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void clearSidsForRole(Role role) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).clear();
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void deleteSids(PermissionEntry sid) {
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            Set<PermissionEntry> sids = entry.getValue();
            sids.remove(sid);
        }
        this.matchingRoleMapCache.invalidateAll();
    }

    @Deprecated
    public void deleteSids(String sid) {
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            Set<PermissionEntry> sids = entry.getValue();
            sids.remove(new PermissionEntry(AuthorizationType.EITHER, sid));
        }
        this.matchingRoleMapCache.invalidateAll();
    }

    public void deleteRoleSid(PermissionEntry sid, String rolename) {
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            if (!role.getName().equals(rolename)) continue;
            this.unAssignRole(role, sid);
            break;
        }
    }

    @Deprecated
    public void deleteRoleSid(String sid, String rolename) {
        PermissionEntry sidEntry = new PermissionEntry(AuthorizationType.EITHER, sid);
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            if (!role.getName().equals(rolename)) continue;
            this.unAssignRole(role, sidEntry);
            break;
        }
    }

    public void clearSids() {
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            this.clearSidsForRole(role);
        }
    }

    @CheckForNull
    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public void removeRole(Role role) {
        this.grantedRoles.remove(role);
        this.matchingRoleMapCache.invalidateAll();
    }

    public SortedMap<Role, Set<PermissionEntry>> getGrantedRolesEntries() {
        return Collections.unmodifiableSortedMap(this.grantedRoles);
    }

    @Deprecated
    public SortedMap<Role, Set<String>> getGrantedRoles() {
        TreeMap<Role, Set<String>> ret = new TreeMap<Role, Set<String>>();
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            Set allGrants = entry.getValue().stream().map(PermissionEntry::getSid).collect(Collectors.toSet());
            ret.put(entry.getKey(), allGrants);
        }
        return ret;
    }

    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.grantedRoles.keySet());
    }

    @Deprecated
    public SortedSet<String> getSids() {
        return this.getSids(false);
    }

    @Deprecated
    public SortedSet<String> getSids(Boolean includeAnonymous) {
        TreeSet<String> ret = new TreeSet<String>(this.getSidEntries(includeAnonymous).stream().map(PermissionEntry::getSid).collect(Collectors.toSet()));
        return ret;
    }

    public SortedSet<PermissionEntry> getSidEntries() {
        return this.getSidEntries(false);
    }

    public SortedSet<PermissionEntry> getSidEntries(Boolean includeAnonymous) {
        TreeSet sids = new TreeSet();
        for (Map.Entry<Role, Set<PermissionEntry>> entry : this.grantedRoles.entrySet()) {
            sids.addAll(entry.getValue());
        }
        if (!includeAnonymous.booleanValue()) {
            sids.remove(new PermissionEntry(AuthorizationType.USER, "anonymous"));
        }
        return Collections.unmodifiableSortedSet(sids);
    }

    @CheckForNull
    public Set<PermissionEntry> getSidEntriesForRole(String roleName) {
        Role role = this.getRole(roleName);
        if (role != null) {
            return Collections.unmodifiableSet((Set)this.grantedRoles.get(role));
        }
        return null;
    }

    @Deprecated
    @CheckForNull
    public Set<String> getSidsForRole(String roleName) {
        Role role = this.getRole(roleName);
        if (role != null) {
            Set ret = (Set)this.grantedRoles.get(role);
            return ret.stream().map(PermissionEntry::getSid).collect(Collectors.toSet());
        }
        return null;
    }

    @NonNull
    public Set<String> getRolesForUser(User user) throws UsernameNotFoundException {
        return this.getRolesForAuth(user.impersonate2());
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public Set<String> getRolesForAuth(Authentication auth) {
        PermissionEntry userEntry = new PermissionEntry(AuthorizationType.USER, auth.getPrincipal().toString());
        HashSet<String> roleSet = new HashSet<String>(this.getRolesForSidEntry(userEntry));
        for (GrantedAuthority group : auth.getAuthorities()) {
            PermissionEntry groupEntry = new PermissionEntry(AuthorizationType.GROUP, group.getAuthority());
            roleSet.addAll(this.getRolesForSidEntry(groupEntry));
        }
        return roleSet;
    }

    private Set<String> getRolesForSidEntry(final PermissionEntry entry) {
        final HashSet<String> roleSet = new HashSet<String>();
        new RoleWalker(){

            @Override
            public void perform(Role current) {
                if (((Set)RoleMap.this.grantedRoles.get(current)).contains(entry)) {
                    roleSet.add(current.getName());
                }
            }
        };
        return roleSet;
    }

    public RoleMap newMatchingRoleMap(String itemNamePrefix) {
        return (RoleMap)this.matchingRoleMapCache.get((Object)itemNamePrefix, this::createMatchingRoleMap);
    }

    private RoleMap createMatchingRoleMap(final String itemNamePrefix) {
        final TreeMap<Role, Set<PermissionEntry>> roleMap = new TreeMap<Role, Set<PermissionEntry>>();
        new RoleWalker(){

            @Override
            public void perform(Role current) {
                Matcher m = current.getPattern().matcher(itemNamePrefix);
                if (m.matches()) {
                    roleMap.put(current, (Set)RoleMap.this.grantedRoles.get(current));
                }
            }
        };
        return new RoleMap(roleMap);
    }

    @Deprecated
    public static List<String> getMatchingJobNames(Pattern pattern, int maxJobs) {
        ArrayList<String> matchingJobNames = new ArrayList<String>();
        for (Item i2 : Jenkins.get().allItems(Item.class, i -> pattern.matcher(i.getFullName()).matches())) {
            if (matchingJobNames.size() >= maxJobs) break;
            matchingJobNames.add(i2.getFullName());
        }
        return matchingJobNames;
    }

    @Restricted(value={NoExternalUse.class})
    static int getMatchingItemNames(@NonNull List<String> matchedItems, Pattern pattern, int maxJobs) {
        int count = 0;
        for (Item i2 : Jenkins.get().allItems(Item.class, i -> pattern.matcher(i.getFullName()).matches())) {
            if (matchedItems.size() < maxJobs) {
                matchedItems.add(i2.getFullName());
            }
            ++count;
        }
        return count;
    }

    @Deprecated
    public static List<String> getMatchingAgentNames(Pattern pattern, int maxAgents) {
        ArrayList<String> matchingAgentNames = new ArrayList<String>();
        for (Node node : Jenkins.get().getNodes()) {
            if (!pattern.matcher(node.getNodeName()).matches()) continue;
            matchingAgentNames.add(node.getNodeName());
            if (matchingAgentNames.size() < maxAgents) continue;
            break;
        }
        return matchingAgentNames;
    }

    @Restricted(value={NoExternalUse.class})
    static int getMatchingAgentNames(@NonNull List<String> matchingAgentNames, Pattern pattern, int maxAgents) {
        int count = 0;
        for (Node node : Jenkins.get().getNodes()) {
            if (!pattern.matcher(node.getNodeName()).matches()) continue;
            if (matchingAgentNames.size() < maxAgents) {
                matchingAgentNames.add(node.getNodeName());
            }
            ++count;
        }
        return count;
    }

    private static boolean shouldCheckParentPermissions() {
        String propertyName = RoleMap.class.getName() + ".checkParentPermissions";
        String value = System.getProperty(propertyName);
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    static {
        Permission.getAll().forEach(RoleMap::cacheImplyingPermissions);
    }

    private abstract class RoleWalker {
        boolean shouldAbort = false;

        RoleWalker() {
            this.walk();
        }

        public void abort() {
            this.shouldAbort = true;
        }

        public void walk() {
            Set<Role> roles = RoleMap.this.getRoles();
            for (Role current : roles) {
                this.perform(current);
                if (!this.shouldAbort) continue;
                break;
            }
        }

        public abstract void perform(Role var1);
    }

    private final class AclImpl
    extends SidACL {
        AccessControlled item;
        RoleType roleType;

        public AclImpl(RoleType roleType, AccessControlled item) {
            this.item = item;
            this.roleType = roleType;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As declared in Jenkins API")
        @CheckForNull
        protected Boolean hasPermission(Sid sid, Permission permission) {
            boolean principal = sid instanceof PrincipalSid;
            PermissionEntry entry = new PermissionEntry(principal ? AuthorizationType.USER : AuthorizationType.GROUP, this.toString(sid));
            if (RoleMap.this.hasPermission(entry, permission, this.roleType, this.item)) {
                ItemGroup parent;
                if (this.item instanceof Item && (parent = ((Item)this.item).getParent()) instanceof Item && (Item.DISCOVER.equals((Object)permission) || Item.READ.equals((Object)permission)) && RoleMap.shouldCheckParentPermissions()) {
                    Permission requiredPermissionOnParent;
                    Permission permission2 = requiredPermissionOnParent = permission == Item.DISCOVER ? Item.DISCOVER : Item.READ;
                    if (!((Item)parent).hasPermission(requiredPermissionOnParent)) {
                        return null;
                    }
                }
                return true;
            }
            if (permission == Item.CREATE && this.item == null) {
                RoleBasedAuthorizationStrategy rbas;
                RoleMap roleMapProject;
                AuthorizationStrategy auth = Jenkins.get().getAuthorizationStrategy();
                ProjectNamingStrategy pns = Jenkins.get().getProjectNamingStrategy();
                if (auth instanceof RoleBasedAuthorizationStrategy && pns instanceof RoleBasedProjectNamingStrategy && (roleMapProject = (rbas = (RoleBasedAuthorizationStrategy)auth).getRoleMap(RoleType.Project)).hasPermission(entry, permission, RoleType.Project, this.item)) {
                    return true;
                }
            }
            return null;
        }
    }
}

